/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.Bits;
import com.intellij.util.io.MappedBufferWrapper;
import com.intellij.util.io.ReadWriteMappedBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PagedFileStorage
implements Forceable {
    private static final int BUFFER_SIZE = 0xA00000;
    private final StorageLock myLock;
    private final byte[] myTypedIOBuffer = new byte[8];
    private boolean isDirty = false;
    private final File myFile;
    private long mySize = -1L;
    @NonNls
    private static final String RW = "rw";
    private static final int MAX_FILLER_SIZE = 8192;

    public PagedFileStorage(File file, StorageLock lock) throws IOException {
        this.myFile = file;
        this.myLock = lock;
    }

    public File getFile() {
        return this.myFile;
    }

    public void putInt(int addr, int value) {
        Bits.putInt(this.myTypedIOBuffer, 0, value);
        this.put(addr, this.myTypedIOBuffer, 0, 4);
    }

    public int getInt(int addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 4);
        return Bits.getInt(this.myTypedIOBuffer, 0);
    }

    public void putLong(int addr, long value) {
        Bits.putLong(this.myTypedIOBuffer, 0, value);
        this.put(addr, this.myTypedIOBuffer, 0, 8);
    }

    public void putByte(int addr, byte b) {
        this.myTypedIOBuffer[0] = b;
        this.put(addr, this.myTypedIOBuffer, 0, 1);
    }

    public byte getByte(int addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 1);
        return this.myTypedIOBuffer[0];
    }

    public long getLong(int addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 8);
        return Bits.getLong(this.myTypedIOBuffer, 0);
    }

    public byte get(int index) {
        int page = index / 0xA00000;
        int offset = index % 0xA00000;
        return this.getBuffer(page).get(offset);
    }

    public void put(int index, byte value) {
        this.isDirty = true;
        int page = index / 0xA00000;
        int offset = index % 0xA00000;
        this.getBuffer(page).put(offset, value);
    }

    public void get(int index, byte[] dst, int offset, int length) {
        int i = index;
        int o = offset;
        int l = length;
        while (l > 0) {
            int page = i / 0xA00000;
            int page_offset = i % 0xA00000;
            int page_len = Math.min(l, 0xA00000 - page_offset);
            ByteBuffer buffer = this.getBuffer(page);
            buffer.position(page_offset);
            buffer.get(dst, o, page_len);
            l -= page_len;
            o += page_len;
            i += page_len;
        }
    }

    public void put(int index, byte[] src, int offset, int length) {
        this.isDirty = true;
        int i = index;
        int o = offset;
        int l = length;
        while (l > 0) {
            int page = i / 0xA00000;
            int page_offset = i % 0xA00000;
            int page_len = Math.min(l, 0xA00000 - page_offset);
            ByteBuffer buffer = this.getBuffer(page);
            buffer.position(page_offset);
            buffer.put(src, o, page_len);
            l -= page_len;
            o += page_len;
            i += page_len;
        }
    }

    public void close() {
        this.force();
        this.unmapAll();
    }

    private void unmapAll() {
        for (Map.Entry entry : this.myLock.myBuffersCache.entrySet()) {
            if (((PageKey)entry.getKey()).owner != this) continue;
            this.myLock.myBuffersCache.remove((PageKey)entry.getKey());
        }
    }

    public void resize(int newSize) throws IOException {
        int oldSize = (int)this.myFile.length();
        if (oldSize == newSize) {
            return;
        }
        this.unmapAll();
        this.resizeFile(newSize);
        int delta = newSize - oldSize;
        if (delta > 0) {
            this.fillWithZeros(oldSize, delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeFile(int newSize) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.myFile, RW);
        try {
            raf.setLength(newSize);
        }
        finally {
            raf.close();
        }
        this.mySize = newSize;
    }

    private void fillWithZeros(int from, int length) {
        byte[] buff = new byte[8192];
        Arrays.fill(buff, (byte)0);
        while (length > 0) {
            int filled = Math.min(length, 8192);
            this.put(from, buff, 0, filled);
            length -= filled;
            from += filled;
        }
    }

    public final long length() {
        if (this.mySize == -1L) {
            this.mySize = this.myFile.length();
        }
        return this.mySize;
    }

    private ByteBuffer getBuffer(int page) {
        return this.myLock.myBuffersCache.get(new PageKey(this, page)).buf();
    }

    @Override
    public void force() {
        for (Map.Entry entry : this.myLock.myBuffersCache.entrySet()) {
            if (((PageKey)entry.getKey()).owner != this) continue;
            ((MappedBufferWrapper)entry.getValue()).flush();
        }
        this.isDirty = false;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    private static class PageKey {
        private PagedFileStorage owner;
        private int page;

        public PageKey(PagedFileStorage owner, int page) {
            this.owner = owner;
            this.page = page;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PageKey)) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (!this.owner.equals(pageKey.owner)) {
                return false;
            }
            return this.page == pageKey.page;
        }

        public int hashCode() {
            return 31 * this.owner.hashCode() + this.page;
        }
    }

    public static class StorageLock {
        private final boolean checkThreadAccess;
        final SLRUCache<PageKey, MappedBufferWrapper> myBuffersCache = new SLRUCache<PageKey, MappedBufferWrapper>(20, 10){

            @Override
            @NotNull
            public MappedBufferWrapper createValue(PageKey key) {
                if (StorageLock.this.checkThreadAccess && !Thread.holdsLock(StorageLock.this)) {
                    throw new IllegalStateException("Must hold StorageLock lock to access PagedFileStorage");
                }
                int off = key.page * 0xA00000;
                if ((long)off > key.owner.length()) {
                    throw new IndexOutOfBoundsException();
                }
                ReadWriteMappedBufferWrapper readWriteMappedBufferWrapper = new ReadWriteMappedBufferWrapper(key.owner.myFile, off, Math.min((int)(key.owner.length() - (long)off), 0xA00000));
                if (readWriteMappedBufferWrapper == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/io/PagedFileStorage$StorageLock$1.createValue must not return null");
                }
                return readWriteMappedBufferWrapper;
            }

            @Override
            protected void onDropFromCache(PageKey key, MappedBufferWrapper buf) {
                buf.dispose();
            }
        };

        public StorageLock() {
            this(true);
        }

        public StorageLock(boolean checkThreadAccess) {
            this.checkThreadAccess = checkThreadAccess;
        }
    }
}

