/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SLRUMap<K, V> {
    private final Map<K, V> myProtectedQueue;
    private final Map<K, V> myProbationalQueue;
    private final int myProtectedQueueSize;
    private final int myProbationalQueueSize;
    private int probationalHits = 0;
    private int protectedHits = 0;
    private int misses = 0;
    private static final int FACTOR = Integer.getInteger("idea.slru.factor", 1);

    public SLRUMap(int protectedQueueSize, int probationalQueueSize) {
        this.myProtectedQueueSize = protectedQueueSize * FACTOR;
        this.myProbationalQueueSize = probationalQueueSize * FACTOR;
        this.myProtectedQueue = new LinkedHashMap<K, V>(10, 0.6f){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (this.size() > SLRUMap.this.myProtectedQueueSize) {
                    SLRUMap.this.myProbationalQueue.put(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
        this.myProbationalQueue = new LinkedHashMap<K, V>(10, 0.6f){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (this.size() > SLRUMap.this.myProbationalQueueSize) {
                    SLRUMap.this.onDropFromCache(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
    }

    @Nullable
    public V get(K key) {
        V value = this.myProtectedQueue.get(key);
        if (value != null) {
            ++this.protectedHits;
            return value;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            ++this.probationalHits;
            this.myProtectedQueue.put(this.getStableKey(key), value);
            return value;
        }
        ++this.misses;
        return null;
    }

    public void put(K key, V value) {
        V oldValue = this.myProtectedQueue.remove(key);
        if (oldValue != null) {
            this.onDropFromCache(key, oldValue);
        }
        if ((oldValue = this.myProbationalQueue.put(this.getStableKey(key), value)) != null) {
            this.onDropFromCache(key, oldValue);
        }
    }

    protected void onDropFromCache(K key, V value) {
    }

    public boolean remove(K key) {
        V value = this.myProtectedQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        return false;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.myProtectedQueue.entrySet());
        set.addAll(this.myProbationalQueue.entrySet());
        return set;
    }

    public void clear() {
        for (Map.Entry<K, V> entry : this.myProtectedQueue.entrySet()) {
            this.onDropFromCache(entry.getKey(), entry.getValue());
        }
        this.myProtectedQueue.clear();
        for (Map.Entry<K, V> entry : this.myProbationalQueue.entrySet()) {
            this.onDropFromCache(entry.getKey(), entry.getValue());
        }
        this.myProbationalQueue.clear();
    }

    protected K getStableKey(K key) {
        if (key instanceof ShareableKey) {
            return (K)((ShareableKey)key).getStableCopy();
        }
        return key;
    }
}

