/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BufferedListConsumer<T>
implements Consumer<List<T>> {
    private final int myInterval;
    private long myTs;
    private final int mySize;
    private final List<T> myBuffer;
    private final Consumer<List<T>> myConsumer;

    public BufferedListConsumer(int size, Consumer<List<T>> consumer, int interval) {
        this.mySize = size;
        this.myBuffer = new ArrayList<T>();
        this.myConsumer = consumer;
        this.myInterval = interval;
        this.myTs = System.currentTimeMillis();
    }

    public void consumeOne(T t) {
        this.consume(Collections.singletonList(t));
    }

    @Override
    public void consume(List<T> list) {
        this.myBuffer.addAll(list);
        long ts = System.currentTimeMillis();
        if (this.mySize <= this.myBuffer.size() || this.myInterval > 0 && ts - (long)this.myInterval > this.myTs) {
            this.myConsumer.consume(new ArrayList<T>(this.myBuffer));
            this.myBuffer.clear();
        }
        this.myTs = ts;
    }

    public void flush() {
        if (!this.myBuffer.isEmpty()) {
            this.myConsumer.consume(new ArrayList<T>(this.myBuffer));
            this.myBuffer.clear();
        }
    }
}

