/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class SideBorder
extends LineBorder {
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int ALL = 15;
    private final int mySideMask;
    private final boolean myDotted;

    public SideBorder(Color color, int mask) {
        this(color, mask, false);
    }

    public SideBorder(Color color, int mask, boolean dotted) {
        super(color, 1);
        this.mySideMask = mask;
        this.myDotted = dotted;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets((this.mySideMask & 2) != 0 ? this.getThickness() : 0, (this.mySideMask & 1) != 0 ? this.getThickness() : 0, (this.mySideMask & 8) != 0 ? this.getThickness() : 0, (this.mySideMask & 4) != 0 ? this.getThickness() : 0);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = (this.mySideMask & 2) != 0 ? this.getThickness() : 0;
        insets.left = (this.mySideMask & 1) != 0 ? this.getThickness() : 0;
        insets.bottom = (this.mySideMask & 8) != 0 ? this.getThickness() : 0;
        insets.right = (this.mySideMask & 4) != 0 ? this.getThickness() : 0;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.getLineColor());
        for (int i = 0; i < this.getThickness(); ++i) {
            if ((this.mySideMask & 1) != 0) {
                this.drawLine(g, x + i, y + i, x + i, height - i - i - 1);
            }
            if ((this.mySideMask & 2) != 0) {
                this.drawLine(g, x + i, y + i, width - i - i - 1, y + i);
            }
            if ((this.mySideMask & 4) != 0) {
                this.drawLine(g, width - i - i - 1, y + i, width - i - i - 1, height - i - i - 1);
            }
            if ((this.mySideMask & 8) == 0) continue;
            this.drawLine(g, x + i, height - i - i - 1, width - i - i - 1, height - i - i - 1);
        }
        g.setColor(oldColor);
    }

    private void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        if (this.myDotted) {
            UIUtil.drawDottedLine((Graphics2D)g, x1, y1, x2, y2, ((Graphics2D)g).getBackground(), this.getLineColor());
        } else {
            UIUtil.drawLine(g, x1, y1, x2, y2);
        }
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }
}

