/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtil;

public class SystemInfo {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase();
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop");
    public static final boolean isWindows = OS_NAME.startsWith("windows");
    public static final boolean isWindowsNT = OS_NAME.startsWith("windows nt");
    public static final boolean isWindows2000 = OS_NAME.startsWith("windows 2000");
    public static final boolean isWindows2003 = OS_NAME.startsWith("windows 2003");
    public static final boolean isWindowsXP = OS_NAME.startsWith("windows xp");
    public static final boolean isWindowsVista = OS_NAME.startsWith("windows vista");
    public static final boolean isWindows7 = OS_NAME.startsWith("windows 7");
    public static final boolean isWindows9x = OS_NAME.startsWith("windows 9") || OS_NAME.startsWith("windows me");
    public static final boolean isOS2 = OS_NAME.startsWith("os/2") || OS_NAME.startsWith("os2");
    public static final boolean isMac = OS_NAME.startsWith("mac");
    public static final boolean isFreeBSD = OS_NAME.startsWith("freebsd");
    public static final boolean isLinux = OS_NAME.startsWith("linux");
    public static final boolean isUnix = !isWindows && !isOS2;
    public static final boolean isKDE = SUN_DESKTOP != null && SUN_DESKTOP.toLowerCase().indexOf("kde") >= 0;
    public static final boolean isGnome = SUN_DESKTOP != null && SUN_DESKTOP.toLowerCase().indexOf("gnome") >= 0;
    public static final boolean isMacSystemMenu = isMac && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
    public static final boolean isFileSystemCaseSensitive = !isWindows && !isOS2 && !isMac;
    public static final boolean is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
    public static final boolean is64Bit = !is32Bit;
    public static final boolean isAMD64 = "amd64".equals(OS_ARCH);
    public static final boolean isMacOSTiger = SystemInfo.isTiger();
    public static final boolean isIntelMac = SystemInfo.isIntelMac();
    public static final boolean isMacOSLeopard = SystemInfo.isLeopard();
    public static final boolean isMacOSSnowLeopard = SystemInfo.isSnowLeopard();
    public static boolean X11PasteEnabledSystem = isUnix && !isMac;

    private static boolean isTiger() {
        return isMac && !OS_VERSION.startsWith("10.0") && !OS_VERSION.startsWith("10.1") && !OS_VERSION.startsWith("10.2") && !OS_VERSION.startsWith("10.3");
    }

    private static boolean isIntelMac() {
        return isMac && "i386".equals(OS_ARCH);
    }

    private static boolean isLeopard() {
        return isMac && SystemInfo.isTiger() && !OS_VERSION.startsWith("10.4");
    }

    private static boolean isSnowLeopard() {
        return isMac && SystemInfo.isLeopard() && !OS_VERSION.startsWith("10.5");
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }
}

