/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import java.lang.reflect.Field;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final ObjectTree<Disposable> ourTree = new ObjectTree();
    private static final ObjectTreeAction<Disposable> ourDisposeAction = new ObjectTreeAction<Disposable>(){

        @Override
        public void execute(Disposable each) {
            each.dispose();
        }

        @Override
        public void beforeTreeExecution(Disposable parent) {
            if (parent instanceof Disposable.Parent) {
                ((Disposable.Parent)parent).beforeTreeDispose();
            }
        }
    };
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    private Disposer() {
    }

    public static Disposable newDisposable() {
        return new Disposable(){

            @Override
            public void dispose() {
            }
        };
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        Disposer.register(parent, child, null);
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child, final @NonNls @Nullable String key) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        assert (parent != child) : " Cannot register to itself";
        ourTree.register(parent, child);
        if (key != null) {
            assert (Disposer.get(key) == null);
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                @Override
                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static boolean isDisposed(Disposable disposable) {
        return !ourTree.containsKey(disposable);
    }

    public static Disposable get(String key) {
        return ourKeyDisposables.get(key);
    }

    public static void dispose(Disposable disposable) {
        Disposer.dispose(disposable, true);
    }

    public static void dispose(Disposable disposable, boolean processUnregistered) {
        ourTree.executeAll(disposable, true, ourDisposeAction, processUnregistered);
    }

    public static void disposeChildAndReplace(Disposable toDipose, Disposable toReplace) {
        ourTree.executeChildAndReplace(toDipose, toReplace, true, ourDisposeAction);
    }

    public static ObjectTree<Disposable> getTree() {
        return ourTree;
    }

    public static void assertIsEmpty() {
        if (ourDebugMode) {
            ourTree.assertIsEmpty();
        }
    }

    public static boolean isEmpty() {
        return ourDebugMode && ourTree.isEmpty();
    }

    public static void setDebugMode(boolean b) {
        ourDebugMode = b;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static void clearOwnFields(Object object) {
        Field[] all;
        for (Field each : all = object.getClass().getDeclaredFields()) {
            if ((each.getModifiers() & 0x18) > 0) continue;
            ReflectionUtil.resetField(object, each);
        }
    }

    @Nullable
    public static <T extends Disposable> T findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull T object) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.findRegisteredObject must not be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.findRegisteredObject must not be null");
        }
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    static {
        ourKeyDisposables = new ConcurrentWeakHashMap<String, Disposable>();
    }
}

