/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.intellij.plugins.intelliLang.util.RegExpUtil;
import org.intellij.plugins.intelliLang.util.StringLiteralReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RegExpEnumReference
extends StringLiteralReference {
    private final String myPattern;

    public RegExpEnumReference(PsiLiteralExpression expression, @NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/java/RegExpEnumReference.<init> must not be null");
        }
        super(expression);
        this.myPattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        Set<String> values = this.getEnumValues();
        if (values == null || values.size() == 0) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/java/RegExpEnumReference.getVariants must not return null");
            return objectArray;
        }
        objectArray = ContainerUtil.map2Array(values, (Function)new Function<String, Object>(){

            public Object fun(String s) {
                return LookupElementBuilder.create((String)s).setIcon(Icons.ENUM_ICON);
            }
        });
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/java/RegExpEnumReference.getVariants must not return null");
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    public PsiElement resolve() {
        Set<String> values = this.getEnumValues();
        return values != null ? (values.contains(this.getValue()) ? this.myValue : null) : null;
    }

    @Nullable
    private Set<String> getEnumValues() {
        return RegExpUtil.getEnumValues(this.myValue.getProject(), this.myPattern);
    }
}

