/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;
import org.jetbrains.idea.eclipse.conversion.EclipseUserLibrariesHelper;
import org.jetbrains.idea.eclipse.importWizard.EclipseProjectFinder;
import org.jetbrains.idea.eclipse.importWizard.EclipseProjectWizardContext;
import org.jetbrains.idea.eclipse.importWizard.Options;

public class EclipseImportBuilder
extends ProjectImportBuilder<String>
implements EclipseProjectWizardContext {
    private static final Icon eclipseIcon = IconLoader.getIcon((String)"/images/eclipse.gif");
    private static final Logger LOG = Logger.getInstance((String)("#" + EclipseImportBuilder.class.getName()));
    private Parameters parameters;

    public String getName() {
        return EclipseBundle.message("eclipse.name", new Object[0]);
    }

    public Icon getIcon() {
        return eclipseIcon;
    }

    @Override
    @Nullable
    public String getRootDirectory() {
        return this.getParameters().root;
    }

    @Override
    public boolean setRootDirectory(final String path) {
        ProgressManager.getInstance().run((Task)new Task.Modal(EclipseImportBuilder.getCurrentProject(), EclipseBundle.message("eclipse.import.scanning", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder$1.run must not be null");
                }
                ArrayList<String> roots = new ArrayList<String>();
                EclipseProjectFinder.findModuleRoots(roots, path);
                EclipseImportBuilder.this.getParameters().workspace = roots;
                EclipseImportBuilder.this.getParameters().root = path;
            }

            public void onCancel() {
                EclipseImportBuilder.this.getParameters().workspace = null;
                EclipseImportBuilder.this.getParameters().root = null;
            }
        });
        return this.getParameters().workspace != null;
    }

    public List<String> getList() {
        return this.getParameters().workspace;
    }

    public boolean isMarked(String element) {
        if (this.getParameters().projectsToConvert != null) {
            return this.getParameters().projectsToConvert.contains(element);
        }
        return !this.getParameters().existingModuleNames.contains(EclipseProjectFinder.findProjectName(element));
    }

    public void setList(List<String> list) {
        this.getParameters().projectsToConvert = list;
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().openModuleSettings;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().openModuleSettings = on;
    }

    public void cleanup() {
        super.cleanup();
        this.parameters = null;
    }

    public boolean validate(Project currentProject, Project dstProject) {
        final Ref refEx = new Ref();
        final HashSet variables = new HashSet();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String path : EclipseImportBuilder.this.getParameters().projectsToConvert) {
                        File classpathfile = new File(path, ".classpath");
                        if (!classpathfile.exists()) continue;
                        Element classpathElement = JDOMUtil.loadDocument((File)classpathfile).getRootElement();
                        EclipseClasspathReader.collectVariables(variables, classpathElement, path);
                    }
                }
                catch (IOException e) {
                    refEx.set((Object)e);
                }
                catch (JDOMException e) {
                    refEx.set((Object)e);
                }
            }
        }, EclipseBundle.message("eclipse.import.converting", new Object[0]), false, currentProject);
        if (!refEx.isNull()) {
            Messages.showErrorDialog((Project)dstProject, (String)((Exception)refEx.get()).getMessage(), (String)this.getTitle());
            return false;
        }
        return ProjectMacrosUtil.checkMacros((Project)dstProject, variables);
    }

    public List<Module> commit(final Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        final TreeSet<String> unknownLibraries = new TreeSet<String>();
        TreeSet<String> unknownJdks = new TreeSet<String>();
        HashSet<String> refsToModules = new HashSet<String>();
        ArrayList<Module> result = new ArrayList<Module>();
        try {
            int resultCode;
            final ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance((Project)project).getModifiableModel();
            final ModifiableRootModel[] rootModels = new ModifiableRootModel[this.getParameters().projectsToConvert.size()];
            HashSet<File> files = new HashSet<File>();
            for (String path : this.getParameters().projectsToConvert) {
                File emlFile;
                String modulesDirectory = this.getParameters().converterOptions.commonModulesDirectory;
                if (modulesDirectory == null) {
                    modulesDirectory = path;
                }
                String moduleName = EclipseProjectFinder.findProjectName(path);
                File imlFile = new File(modulesDirectory + File.separator + moduleName + ".iml");
                if (imlFile.isFile()) {
                    files.add(imlFile);
                }
                if (!(emlFile = new File(modulesDirectory + File.separator + moduleName + ".eml")).isFile()) continue;
                files.add(emlFile);
            }
            if (!files.isEmpty() && (resultCode = Messages.showYesNoCancelDialog((String)(ApplicationInfoEx.getInstanceEx().getFullApplicationName() + " module files found:\n" + StringUtil.join(files, (Function)new Function<File, String>(){

                public String fun(File file) {
                    return file.getPath();
                }
            }, (String)"\n") + ".\n Would you like to reuse them?"), (String)"Module files found", (Icon)Messages.getQuestionIcon())) != 0) {
                if (resultCode == 1) {
                    LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                    for (File file : files) {
                        final VirtualFile virtualFile = localFileSystem.findFileByIoFile(file);
                        if (virtualFile != null) {
                            final IOException[] ex = new IOException[1];
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        virtualFile.delete((Object)this);
                                    }
                                    catch (IOException e) {
                                        ex[0] = e;
                                    }
                                }
                            });
                            if (ex[0] == null) continue;
                            throw ex[0];
                        }
                        FileUtil.delete((File)file);
                    }
                } else {
                    return result;
                }
            }
            int idx = 0;
            HashSet<String> usedVariables = new HashSet<String>();
            for (String path : this.getParameters().projectsToConvert) {
                String modulesDirectory = this.getParameters().converterOptions.commonModulesDirectory;
                if (modulesDirectory == null) {
                    modulesDirectory = path;
                }
                Module module = moduleModel.newModule(modulesDirectory + "/" + EclipseProjectFinder.findProjectName(path) + ".iml", StdModuleTypes.JAVA);
                result.add(module);
                final ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                rootModels[idx++] = rootModel;
                File classpathFile = new File(path, ".classpath");
                EclipseClasspathReader classpathReader = new EclipseClasspathReader(path, project, this.getParameters().projectsToConvert);
                classpathReader.init(rootModel);
                if (classpathFile.exists()) {
                    Element classpathElement = JDOMUtil.loadDocument((File)classpathFile).getRootElement();
                    classpathReader.readClasspath(rootModel, unknownLibraries, unknownJdks, usedVariables, refsToModules, this.getParameters().converterOptions.testPattern, classpathElement);
                } else {
                    EclipseClasspathReader.setupOutput(rootModel, path + "/bin");
                }
                ClasspathStorage.setStorageType((ModifiableRootModel)rootModel, (String)(this.getParameters().linkConverted ? "eclipse" : "default"));
                if (model == null) continue;
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        rootModel.commit();
                    }
                });
            }
            if (model == null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ProjectRootManagerEx.getInstanceEx((Project)project).multiCommit(moduleModel, rootModels);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        EclipseImportBuilder.createEclipseLibrary(project, unknownLibraries, "ECLIPSE");
        StringBuffer message = new StringBuffer();
        refsToModules.removeAll(this.getParameters().existingModuleNames);
        for (String path : this.getParameters().projectsToConvert) {
            String projectName = EclipseProjectFinder.findProjectName(path);
            if (projectName == null) continue;
            refsToModules.remove(projectName);
            this.getParameters().existingModuleNames.add(projectName);
        }
        if (!refsToModules.isEmpty()) {
            message.append("Unknown modules detected");
            for (String module : refsToModules) {
                message.append("\n").append(module);
            }
        }
        if (!unknownJdks.isEmpty()) {
            if (message.length() > 0) {
                message.append("\nand jdks");
            } else {
                message.append("Imported project refers to unknown jdks");
            }
            for (String unknownJdk : unknownJdks) {
                message.append("\n").append(unknownJdk);
            }
        }
        if (!unknownLibraries.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            buf.append("<html><body>");
            buf.append(EclipseBundle.message("eclipse.import.warning.undefinded.libraries", new Object[0]));
            for (String name : unknownLibraries) {
                buf.append("<br>").append(name);
            }
            if (model == null) {
                buf.append("<br><b>Please export Eclipse user libraries and import them now from resulted .userlibraries file</b>");
                buf.append("</body></html>");
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file) {
                        return super.isFileSelectable(file) && Comparing.strEqual((String)file.getExtension(), (String)"userlibraries");
                    }
                };
                descriptor.setDescription(buf.toString());
                descriptor.setTitle(this.getTitle());
                final VirtualFile[] selectedFiles = FileChooser.chooseFiles((Project)project, (FileChooserDescriptor)descriptor, (VirtualFile)project.getBaseDir());
                if (selectedFiles.length == 1) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                EclipseUserLibrariesHelper.readProjectLibrariesContent(new File(selectedFiles[0].getPath()), project, unknownLibraries);
                            }
                            catch (Exception e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    });
                }
            }
        }
        if (message.length() > 0) {
            Messages.showErrorDialog((Project)project, (String)message.toString(), (String)this.getTitle());
        }
        return result;
    }

    private static void createEclipseLibrary(final Project project, Collection<String> libraries, final String libraryName) {
        if (libraries.contains(libraryName)) {
            VirtualFile pluginsDir;
            FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false){

                public Icon getOpenIcon(VirtualFile virtualFile) {
                    return this.looksLikeEclipse(virtualFile) ? eclipseIcon : super.getOpenIcon(virtualFile);
                }

                public Icon getClosedIcon(VirtualFile virtualFile) {
                    return this.looksLikeEclipse(virtualFile) ? eclipseIcon : super.getClosedIcon(virtualFile);
                }

                private boolean looksLikeEclipse(VirtualFile virtualFile) {
                    return virtualFile.findChild(".eclipseproduct") != null;
                }
            };
            fileChooserDescriptor.setTitle(EclipseBundle.message("eclipse.create.library.title", new Object[0]));
            fileChooserDescriptor.setDescription(EclipseBundle.message("eclipse.create.library.description", libraryName));
            VirtualFile[] files = FileChooser.chooseFiles((Project)project, (FileChooserDescriptor)fileChooserDescriptor);
            if (files.length == 1 && (pluginsDir = files[0].findChild("plugins")) != null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel("application", project);
                        assert (table != null);
                        LibraryTable.ModifiableModel tableModel = table.getModifiableModel();
                        Library library = tableModel.createLibrary(libraryName);
                        Library.ModifiableModel libraryModel = library.getModifiableModel();
                        libraryModel.addJarDirectory(pluginsDir, true);
                        libraryModel.commit();
                        tableModel.commit();
                    }
                });
                libraries.remove(libraryName);
            }
        }
    }

    public Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters();
            this.parameters.existingModuleNames = new HashSet<String>();
            if (this.isUpdate()) {
                for (Module module : ModuleManager.getInstance((Project)EclipseImportBuilder.getCurrentProject()).getModules()) {
                    this.parameters.existingModuleNames.add(module.getName());
                }
            }
        }
        return this.parameters;
    }

    public static class Parameters {
        public String root;
        public List<String> workspace;
        public boolean linkConverted;
        public List<String> projectsToConvert = new ArrayList<String>();
        public boolean openModuleSettings;
        public Options converterOptions = new Options();
        public Set<String> existingModuleNames;
    }
}

