/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ConditionalUtils;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import com.siyeh.ipp.trivialif.ReplaceIfWithConditionalPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceIfWithConditionalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ReplaceIfWithConditionalPredicate replaceIfWithConditionalPredicate = new ReplaceIfWithConditionalPredicate();
        if (replaceIfWithConditionalPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/trivialif/ReplaceIfWithConditionalIntention.getElementPredicate must not return null");
        }
        return replaceIfWithConditionalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/trivialif/ReplaceIfWithConditionalIntention.processIntention must not be null");
        }
        PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
        if (ifStatement == null) {
            return;
        }
        if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiExpressionStatement strippedThenBranch = (PsiExpressionStatement)ConditionalUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiExpressionStatement strippedElseBranch = (PsiExpressionStatement)ConditionalUtils.stripBraces(elseBranch);
            PsiAssignmentExpression thenAssign = (PsiAssignmentExpression)strippedThenBranch.getExpression();
            PsiAssignmentExpression elseAssign = (PsiAssignmentExpression)strippedElseBranch.getExpression();
            PsiExpression lhs = thenAssign.getLExpression();
            String lhsText = lhs.getText();
            PsiJavaToken sign = thenAssign.getOperationSign();
            String operator = sign.getText();
            PsiExpression thenRhs = thenAssign.getRExpression();
            if (thenRhs == null) {
                return;
            }
            PsiExpression elseRhs = elseAssign.getRExpression();
            if (elseRhs == null) {
                return;
            }
            String conditional = ReplaceIfWithConditionalIntention.getConditionalText(condition, thenRhs, elseRhs, thenAssign.getType());
            ReplaceIfWithConditionalIntention.replaceStatement(lhsText + operator + conditional + ';', (PsiStatement)ifStatement);
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiReturnStatement thenReturn = (PsiReturnStatement)ConditionalUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiReturnStatement elseReturn = (PsiReturnStatement)ConditionalUtils.stripBraces(elseBranch);
            PsiExpression thenReturnValue = thenReturn.getReturnValue();
            if (thenReturnValue == null) {
                return;
            }
            PsiExpression elseReturnValue = elseReturn.getReturnValue();
            if (elseReturnValue == null) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)thenReturn, PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiType returnType = method.getReturnType();
            String conditional = ReplaceIfWithConditionalIntention.getConditionalText(condition, thenReturnValue, elseReturnValue, returnType);
            ReplaceIfWithConditionalIntention.replaceStatement("return " + conditional + ';', (PsiStatement)ifStatement);
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableImplicitReturn(ifStatement)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiStatement rawThenBranch = ifStatement.getThenBranch();
            PsiReturnStatement thenBranch = (PsiReturnStatement)ConditionalUtils.stripBraces(rawThenBranch);
            PsiExpression thenReturnValue = thenBranch.getReturnValue();
            if (thenReturnValue == null) {
                return;
            }
            PsiReturnStatement elseBranch = (PsiReturnStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)ifStatement, PsiReturnStatement.class);
            if (elseBranch == null) {
                return;
            }
            PsiExpression elseReturnValue = elseBranch.getReturnValue();
            if (elseReturnValue == null) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)thenBranch, PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiType methodType = method.getReturnType();
            String conditional = ReplaceIfWithConditionalIntention.getConditionalText(condition, thenReturnValue, elseReturnValue, methodType);
            if (conditional == null) {
                return;
            }
            ReplaceIfWithConditionalIntention.replaceStatement("return " + conditional + ';', (PsiStatement)ifStatement);
            elseBranch.delete();
        }
    }

    private static String getConditionalText(PsiExpression condition, PsiExpression thenValue, PsiExpression elseValue, PsiType requiredType) {
        condition = ParenthesesUtils.stripParentheses(condition);
        if ((thenValue = ParenthesesUtils.stripParentheses(thenValue)) == null) {
            return null;
        }
        if ((elseValue = ParenthesesUtils.stripParentheses(elseValue)) == null) {
            return null;
        }
        StringBuilder conditional = new StringBuilder();
        String conditionText = ReplaceIfWithConditionalIntention.getExpressionText(condition);
        conditional.append(conditionText);
        conditional.append('?');
        PsiType thenType = thenValue.getType();
        PsiType elseType = elseValue.getType();
        if (thenType instanceof PsiPrimitiveType && !PsiType.NULL.equals(thenType) && !(elseType instanceof PsiPrimitiveType) && !(requiredType instanceof PsiPrimitiveType)) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)thenType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(");
            conditional.append(thenValue.getText());
            conditional.append("):");
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(elseValue));
        } else if (elseType instanceof PsiPrimitiveType && !PsiType.NULL.equals(elseType) && !(thenType instanceof PsiPrimitiveType) && !(requiredType instanceof PsiPrimitiveType)) {
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(thenValue));
            conditional.append(':');
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)elseType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(");
            conditional.append(elseValue.getText());
            conditional.append(')');
        } else {
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(thenValue));
            conditional.append(':');
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(elseValue));
        }
        return conditional.toString();
    }

    private static String getExpressionText(PsiExpression expression) {
        if (ParenthesesUtils.getPrecedence(expression) <= 15) {
            return expression.getText();
        }
        return '(' + expression.getText() + ')';
    }
}

