/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.psiutils.EquivalenceChecker;
import com.siyeh.ipp.psiutils.SideEffectChecker;
import com.siyeh.ipp.switchtoif.LabelSearchVisitor;
import com.siyeh.ipp.switchtoif.LocalVariableUsageVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class CaseUtil {
    private CaseUtil() {
    }

    private static boolean canBeCaseLabel(PsiExpression expression) {
        PsiElement referent;
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiReferenceExpression && (referent = ((PsiReference)expression).resolve()) instanceof PsiEnumConstant) {
            return true;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type.equals(PsiType.INT) || type.equals(PsiType.CHAR) || type.equals(PsiType.LONG) || type.equals(PsiType.SHORT))) {
            return false;
        }
        return PsiUtil.isConstantExpression((PsiExpression)expression);
    }

    public static boolean containsHiddenBreak(PsiStatement statement) {
        return CaseUtil.containsHiddenBreak(statement, true);
    }

    private static boolean containsHiddenBreak(PsiStatement statement, boolean isTopLevel) {
        if (statement instanceof PsiBlockStatement) {
            PsiStatement[] statements;
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            for (PsiStatement childStatement : statements = codeBlock.getStatements()) {
                if (!CaseUtil.containsHiddenBreak(childStatement, false)) continue;
                return true;
            }
        } else {
            if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiStatement thenBranch = ifStatement.getThenBranch();
                PsiStatement elseBranch = ifStatement.getElseBranch();
                return CaseUtil.containsHiddenBreak(thenBranch, false) || CaseUtil.containsHiddenBreak(elseBranch, false);
            }
            if (statement instanceof PsiBreakStatement) {
                if (isTopLevel) {
                    return false;
                }
                PsiIdentifier identifier = ((PsiBreakStatement)statement).getLabelIdentifier();
                if (identifier == null) {
                    return true;
                }
                String text = identifier.getText();
                return "".equals(text);
            }
        }
        return false;
    }

    public static boolean isUsedByStatementList(PsiLocalVariable variable, List<PsiElement> elements) {
        for (PsiElement element : elements) {
            if (!CaseUtil.isUsedByStatement(variable, element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUsedByStatement(PsiLocalVariable variable, PsiElement statement) {
        LocalVariableUsageVisitor visitor = new LocalVariableUsageVisitor(variable);
        statement.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }

    public static String findUniqueLabel(PsiStatement statement, @NonNls String baseName) {
        PsiStatement ancestor = statement;
        while (!(ancestor.getParent() == null || ancestor instanceof PsiMethod || ancestor instanceof PsiClass || ancestor instanceof PsiFile)) {
            ancestor = ancestor.getParent();
        }
        if (!CaseUtil.checkForLabel(baseName, (PsiElement)ancestor)) {
            return baseName;
        }
        int val = 1;
        String name;
        while (CaseUtil.checkForLabel(name = baseName + val, (PsiElement)ancestor)) {
            ++val;
        }
        return name;
    }

    private static boolean checkForLabel(String name, PsiElement ancestor) {
        LabelSearchVisitor visitor = new LabelSearchVisitor(name);
        ancestor.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }

    @Nullable
    public static PsiExpression getCaseExpression(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        List<PsiExpression> possibleCaseExpressions = CaseUtil.determinePossibleCaseExpressions(condition);
        if (possibleCaseExpressions == null) {
            return null;
        }
        for (PsiExpression possibleCaseExpression : possibleCaseExpressions) {
            PsiExpression caseCondition;
            PsiExpression caseExpression = possibleCaseExpression;
            if (SideEffectChecker.mayHaveSideEffects(caseExpression)) continue;
            PsiIfStatement statementToCheck = statement;
            while (CaseUtil.canBeMadeIntoCase(caseCondition = statementToCheck.getCondition(), caseExpression)) {
                PsiStatement elseBranch = statementToCheck.getElseBranch();
                if (elseBranch == null || !(elseBranch instanceof PsiIfStatement)) {
                    return caseExpression;
                }
                statementToCheck = (PsiIfStatement)elseBranch;
            }
        }
        return null;
    }

    private static List<PsiExpression> determinePossibleCaseExpressions(PsiExpression expression) {
        PsiExpression expressionToCheck = expression;
        while (expressionToCheck instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expressionToCheck;
            expressionToCheck = parenthesizedExpression.getExpression();
        }
        ArrayList<PsiExpression> out = new ArrayList<PsiExpression>(10);
        if (!(expressionToCheck instanceof PsiBinaryExpression)) {
            return out;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expressionToCheck;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType operation = sign.getTokenType();
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiExpression rhs = binaryExpression.getROperand();
        if (operation.equals(JavaTokenType.OROR)) {
            return CaseUtil.determinePossibleCaseExpressions(lhs);
        }
        if (operation.equals(JavaTokenType.EQEQ)) {
            if (CaseUtil.canBeCaseLabel(lhs)) {
                out.add(rhs);
            }
            if (CaseUtil.canBeCaseLabel(rhs)) {
                out.add(lhs);
            }
        }
        return out;
    }

    private static boolean canBeMadeIntoCase(PsiExpression expression, PsiExpression caseExpression) {
        PsiExpression expressionToCheck = expression;
        while (expressionToCheck instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expressionToCheck;
            expressionToCheck = parenthesizedExpression.getExpression();
        }
        if (!(expressionToCheck instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expressionToCheck;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType operation = sign.getTokenType();
        PsiExpression lOperand = binaryExpression.getLOperand();
        PsiExpression rhs = binaryExpression.getROperand();
        if (operation.equals(JavaTokenType.OROR)) {
            return CaseUtil.canBeMadeIntoCase(lOperand, caseExpression) && CaseUtil.canBeMadeIntoCase(rhs, caseExpression);
        }
        if (operation.equals(JavaTokenType.EQEQ)) {
            if (CaseUtil.canBeCaseLabel(lOperand) && EquivalenceChecker.expressionsAreEquivalent(caseExpression, rhs)) {
                return true;
            }
            return CaseUtil.canBeCaseLabel(rhs) && EquivalenceChecker.expressionsAreEquivalent(caseExpression, lOperand);
        }
        return false;
    }
}

