/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtils {
    private ExpressionUtils() {
    }

    @Nullable
    public static Object computeConstantExpression(PsiExpression expression) {
        return ExpressionUtils.computeConstantExpression(expression, false);
    }

    public static Object computeConstantExpression(PsiExpression expression, boolean throwExceptionOnOverflow) {
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
        return constantEvaluationHelper.computeConstantExpression((PsiElement)expression, throwExceptionOnOverflow);
    }

    public static boolean isNegated(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        return JavaTokenType.MINUS.equals(tokenType);
    }
}

