/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.parenthesis;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import com.siyeh.ipp.psiutils.ParenthesesUtils;

class UnnecessaryParenthesesPredicate
implements PsiElementPredicate {
    UnnecessaryParenthesesPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        int childPrecedence;
        if (!(element instanceof PsiParenthesizedExpression)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        PsiParenthesizedExpression expression = (PsiParenthesizedExpression)element;
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpression)) {
            return true;
        }
        PsiExpression body = expression.getExpression();
        if (body instanceof PsiParenthesizedExpression) {
            return true;
        }
        int parentPrecedence = ParenthesesUtils.getPrecedence((PsiExpression)parent);
        if (parentPrecedence > (childPrecedence = ParenthesesUtils.getPrecedence(body))) {
            return true;
        }
        if (parentPrecedence == childPrecedence) {
            if (parent instanceof PsiBinaryExpression && body instanceof PsiBinaryExpression) {
                PsiJavaToken childSign;
                IElementType childOperator;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
                PsiJavaToken parentSign = binaryExpression.getOperationSign();
                IElementType parentOperator = parentSign.getTokenType();
                if (!parentOperator.equals(childOperator = (childSign = ((PsiBinaryExpression)body).getOperationSign()).getTokenType())) {
                    return false;
                }
                PsiType parentType = binaryExpression.getType();
                PsiType bodyType = body.getType();
                return parentType != null && parentType.equals(bodyType);
            }
            return false;
        }
        return false;
    }
}

