/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.Nullable;

class StringConcatPredicate
implements PsiElementPredicate {
    StringConcatPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiType prefixExpressionType;
        PsiJavaToken token;
        IElementType tokenType;
        if (element instanceof PsiJavaToken ? !(tokenType = (token = (PsiJavaToken)element).getTokenType()).equals(JavaTokenType.PLUS) : !(element instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType tokenType2 = sign.getTokenType();
        if (!tokenType2.equals(JavaTokenType.PLUS)) {
            return false;
        }
        PsiType type = binaryExpression.getType();
        if (type == null || !type.equalsToText("java.lang.String")) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiExpression rightMostExpression = StringConcatPredicate.getRightmostExpression(lhs);
        if (rightMostExpression instanceof PsiPrefixExpression && ((prefixExpressionType = rightMostExpression.getType()) == null || prefixExpressionType.equalsToText("java.lang.String"))) {
            return false;
        }
        return PsiUtil.isConstantExpression((PsiExpression)rhs) && PsiUtil.isConstantExpression((PsiExpression)rightMostExpression);
    }

    @Nullable
    private static PsiExpression getRightmostExpression(PsiExpression expression) {
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression rhs = binaryExpression.getROperand();
            return StringConcatPredicate.getRightmostExpression(rhs);
        }
        return expression;
    }
}

