/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts;

import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.FileSystemTreeFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class SelectLocationStep
extends WizardStep {
    protected final FileSystemTree myFileSystemTree;
    private ActionToolbar myFileSystemToolBar;
    private VirtualFile mySelectedFile;
    private final TreeSelectionListener myTreeSelectionListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            SelectLocationStep.this.getWizard().updateStep();
        }
    };

    public SelectLocationStep(String description, CvsWizard wizard, final @Nullable Project project) {
        super(description, wizard);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                return showHiddenFiles || project == null || project.isDefault() || !ProjectRootManager.getInstance((Project)project).getFileIndex().isIgnored(file);
            }
        };
        this.myFileSystemTree = FileSystemTreeFactory.SERVICE.getInstance().createFileSystemTree(project, descriptor);
        this.myFileSystemTree.updateTree();
        JTree tree = this.myFileSystemTree.getTree();
        tree.addSelectionPath(tree.getPathForRow(0));
    }

    @Override
    protected void init() {
        final DefaultActionGroup fileSystemActionGroup = this.createFileSystemActionGroup();
        this.myFileSystemToolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)fileSystemActionGroup, true);
        this.myFileSystemTree.getTree().getSelectionModel().addTreeSelectionListener(this.myTreeSelectionListener);
        this.myFileSystemTree.getTree().setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myFileSystemTree.getTree().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("UpdatePopup", (ActionGroup)fileSystemActionGroup);
                popupMenu.getComponent().show(comp, x, y);
            }
        });
        super.init();
    }

    @Override
    protected JComponent createComponent() {
        MyPanel result = new MyPanel();
        result.add((Component)this.myFileSystemToolBar.getComponent(), "North");
        result.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myFileSystemTree.getTree()), "Center");
        return result;
    }

    @Override
    protected void dispose() {
        this.mySelectedFile = this.myFileSystemTree.getSelectedFile();
        this.myFileSystemTree.getTree().getSelectionModel().removeTreeSelectionListener(this.myTreeSelectionListener);
        Disposer.dispose((Disposable)this.myFileSystemTree);
    }

    @Override
    public boolean nextIsEnabled() {
        return this.myFileSystemTree.getSelectedFile() != null;
    }

    @Override
    public boolean setActive() {
        return true;
    }

    private DefaultActionGroup createFileSystemActionGroup() {
        DefaultActionGroup group = FileSystemTreeFactory.SERVICE.getInstance().createDefaultFileSystemActions(this.myFileSystemTree);
        AnAction[] actions = this.getActions();
        if (actions.length > 0) {
            group.addSeparator();
        }
        for (AnAction action : actions) {
            group.add(action);
        }
        return group;
    }

    protected AnAction[] getActions() {
        return AnAction.EMPTY_ARRAY;
    }

    public File getSelectedFile() {
        if (this.mySelectedFile != null) {
            return CvsVfsUtil.getFileFor(this.mySelectedFile);
        }
        return CvsVfsUtil.getFileFor(this.myFileSystemTree.getSelectedFile());
    }

    @Override
    public Component getPreferredFocusedComponent() {
        return this.myFileSystemTree.getTree();
    }

    private class MyPanel
    extends JPanel
    implements TypeSafeDataProvider {
        private MyPanel() {
            super(new BorderLayout());
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key == PlatformDataKeys.VIRTUAL_FILE_ARRAY) {
                sink.put(PlatformDataKeys.VIRTUAL_FILE_ARRAY, (Object)SelectLocationStep.this.myFileSystemTree.getSelectedFiles());
            } else if (key == FileSystemTree.DATA_KEY) {
                sink.put(FileSystemTree.DATA_KEY, (Object)SelectLocationStep.this.myFileSystemTree);
            }
        }
    }
}

