/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsStatus;

import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import java.io.File;
import java.util.Collection;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.file.FileStatus;

public class StatusOperation
extends CvsOperationOnFiles {
    private static final String ourNoneTag = "(none)";
    private String myRepositoryRevision;
    private FileStatus myStatus;
    private String myStickyDate;
    private String myStickyTag;

    public StatusOperation(Collection<File> files) {
        for (File file : files) {
            this.addFile(file);
        }
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        StatusCommand command = new StatusCommand();
        this.addFilesToCommand(root, (AbstractCommand)command);
        return command;
    }

    @Override
    protected String getOperationName() {
        return "status";
    }

    @Override
    public void fileInfoGenerated(Object info) {
        super.fileInfoGenerated(info);
        if (info instanceof StatusInformation) {
            StatusInformation statusInformation = (StatusInformation)info;
            this.myRepositoryRevision = statusInformation.getRepositoryRevision();
            this.myStatus = statusInformation.getStatus();
            this.myStickyDate = statusInformation.getStickyDate();
            this.myStickyDate = ourNoneTag.equals(this.myStickyDate) ? null : this.myStickyDate;
            this.myStickyTag = statusInformation.getStickyTag();
            this.myStickyTag = ourNoneTag.equals(this.myStickyTag) ? null : this.myStickyTag;
        }
    }

    public String getRepositoryRevision() {
        return this.myRepositoryRevision;
    }

    public FileStatus getStatus() {
        return this.myStatus;
    }

    public String getStickyDate() {
        return this.myStickyDate;
    }

    public String getStickyTag() {
        return this.myStickyTag;
    }
}

