/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsoperations.common.CompositeOperaton;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddFileOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsCommit.CommitFilesOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsRemove.RemoveFilesOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class RepositoryModificationOperation
extends CompositeOperaton {
    private final CvsOperationOnFiles myRemoveRequests = new RemoveFilesOperation();
    private final CommitFilesOperation myCommitRequests;
    private int myAddedFilesCount = 0;

    public static RepositoryModificationOperation createGlobalTransactionOperation(String message, CvsConfiguration configuration) {
        return new RepositoryModificationOperation(message, configuration);
    }

    private RepositoryModificationOperation(String message, CvsConfiguration configuration) {
        this.myCommitRequests = new CommitFilesOperation(message, configuration.MAKE_NEW_FILES_READONLY);
        this.addOperation(this.myRemoveRequests);
    }

    public void commitFile(String path) {
        this.commitFile(new File(path).getAbsoluteFile());
    }

    private void commitFile(File file) {
        this.myCommitRequests.addFile(file.getAbsolutePath());
    }

    public void addFile(String folderPath, String name, KeywordSubstitution substitution) {
        ++this.myAddedFilesCount;
        File file = new File(folderPath, name).getAbsoluteFile();
        AddFileOperation addFilesOperation = new AddFileOperation(substitution);
        addFilesOperation.addFile(file.getAbsolutePath());
        this.addOperation(addFilesOperation);
        if (file.isFile()) {
            this.commitFile(file);
        }
    }

    public void removeFile(String path) {
        File file = new File(path).getAbsoluteFile();
        this.myRemoveRequests.addFile(file.getAbsolutePath());
        this.commitFile(file);
    }

    @Override
    public int getFilesToProcessCount() {
        int filesToRemove = this.myRemoveRequests.getFilesCount();
        int filesToChange = this.myCommitRequests.getFilesCount() - this.myAddedFilesCount - filesToRemove;
        return this.myAddedFilesCount * 4 + filesToRemove * 2 + filesToChange * 2;
    }

    public void setMessage(Object parameters) {
        this.myCommitRequests.setMessage(parameters);
    }

    @Override
    protected List<CvsOperation> getSubOperations() {
        ArrayList<CvsOperation> result = new ArrayList<CvsOperation>(super.getSubOperations());
        result.add(this.myCommitRequests);
        return result;
    }
}

