/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public abstract class LoginPerformer<T extends CvsEnvironment> {
    private final Collection<T> myRoots;
    private final Consumer<VcsException> myExceptionConsumer;
    private boolean myForceCheck;

    public LoginPerformer(Collection<T> roots, Consumer<VcsException> exceptionConsumer) {
        this.myRoots = roots;
        this.myExceptionConsumer = exceptionConsumer;
        this.myForceCheck = false;
    }

    public void setForceCheck(boolean forceCheck) {
        this.myForceCheck = forceCheck;
    }

    @Nullable
    protected abstract Project getProject(T var1);

    public boolean loginAll(ModalityContext executor) {
        return this.loginAll(executor, true);
    }

    public boolean loginAll(ModalityContext executor, boolean goOffline) {
        for (CvsEnvironment root : this.myRoots) {
            Project project;
            CvsLoginWorker worker = root.getLoginWorker(executor, project = this.getProject(root));
            ThreeState checkResult = LoginPerformer.checkLoginWorker(worker, executor, project, this.myForceCheck);
            if (ThreeState.YES.equals((Object)checkResult)) continue;
            if (ThreeState.UNSURE.equals((Object)checkResult)) {
                if (goOffline) {
                    worker.goOffline();
                }
                this.myExceptionConsumer.consume((Object)new CvsException("Authentication canceled", root.getCvsRootAsString()));
            }
            return false;
        }
        return true;
    }

    public static ThreeState checkLoginWorker(final CvsLoginWorker worker, ModalityContext executor, Project project, boolean forceCheckParam) {
        boolean forceCheck = forceCheckParam;
        final Ref promptResult = new Ref();
        Runnable prompt = new Runnable(){

            @Override
            public void run() {
                promptResult.set((Object)worker.promptForPassword());
            }
        };
        ThreeState state;
        while (!ThreeState.YES.equals((Object)(state = worker.silentLogin(forceCheck)))) {
            if (ThreeState.NO.equals((Object)state)) {
                return state;
            }
            executor.runInDispatchThread(prompt, project);
            if (!Boolean.TRUE.equals(promptResult.get())) {
                return ThreeState.UNSURE;
            }
            forceCheck = true;
        }
        return ThreeState.YES;
    }

    public static class MyForRootProvider
    extends LoginPerformer<CvsRootProvider> {
        private ProjectLocator myProjectLocator = ProjectLocator.getInstance();
        private LocalFileSystem myLfs = LocalFileSystem.getInstance();

        public MyForRootProvider(Collection<CvsRootProvider> roots, Consumer<VcsException> exceptionConsumer) {
            super(roots, exceptionConsumer);
        }

        @Override
        @Nullable
        protected Project getProject(CvsRootProvider root) {
            VirtualFile vf = root.getLocalRoot() == null ? null : this.myLfs.findFileByIoFile(root.getLocalRoot());
            return vf == null ? null : this.myProjectLocator.guessProjectForFile(vf);
        }
    }

    public static class MyProjectKnown
    extends LoginPerformer<CvsEnvironment> {
        private final Project myProject;

        public MyProjectKnown(Project project, Collection<CvsEnvironment> roots, Consumer<VcsException> exceptionConsumer) {
            super(roots, exceptionConsumer);
            this.myProject = project;
        }

        @Override
        protected Project getProject(CvsEnvironment root) {
            return this.myProject;
        }
    }
}

