/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesAdapter;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.MessageEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.EditorAdapter;

public class CvsMessagesConsole
extends CvsMessagesAdapter {
    private EditorAdapter myOutput;
    public static final TextAttributes USER_MESSAGES_ATTRIBUTES = new TextAttributes(null, null, null, EffectType.LINE_UNDERSCORE, 0);
    public static final TextAttributes PROGRESS_MESSAGES_ATTRIBUTES = new TextAttributes(null, null, null, EffectType.LINE_UNDERSCORE, 2);
    public static final TextAttributes COMMAND = new TextAttributes(null, null, null, EffectType.LINE_UNDERSCORE, 1);

    public void connectToOutputView(Editor editor, Project project) {
        this.myOutput = new EditorAdapter(editor, project);
    }

    @Override
    public void addMessage(MessageEvent event) {
        if (this.hasNotEmptyMessage(event)) {
            this.appendString(event.getMessage(), this.getAttributesFor(event));
        }
    }

    private void appendString(String message, TextAttributes attributes) {
        if (this.myOutput == null) {
            return;
        }
        this.myOutput.appendString(message, attributes);
    }

    private TextAttributes getAttributesFor(MessageEvent event) {
        if (event.isError() || event.isTagged()) {
            return USER_MESSAGES_ATTRIBUTES;
        }
        return PROGRESS_MESSAGES_ATTRIBUTES;
    }

    private boolean hasNotEmptyMessage(MessageEvent event) {
        return event.getMessage().length() > 0;
    }

    @Override
    public void commandStarted(String command) {
        this.appendString(command, COMMAND);
    }

    @Override
    public void commandFinished(String commandName, long time) {
        this.appendString(CvsBundle.message((String)"message.command.finished", (Object[])new Object[]{time / 1000L}), COMMAND);
    }
}

