/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.history.ComparableVcsRevisionOnOperation;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import javax.swing.Icon;

public class CvsFile
extends CvsElement {
    private VirtualFile myVirtualFile;
    private final CvsEnvironment myEnvironment;
    private final Project myProject;

    public CvsFile(String name, CvsEnvironment env, Project project) {
        super(CvsFile.getFileIcon(name), project);
        this.myEnvironment = env;
        this.myProject = project;
    }

    private static Icon getFileIcon(String name) {
        try {
            return FileTypeManager.getInstance().getFileTypeByFileName(name).getIcon();
        }
        catch (Exception ex) {
            return FileTypes.UNKNOWN.getIcon();
        }
    }

    @Override
    public VirtualFile getVirtualFile() {
        if (this.myVirtualFile == null) {
            this.myVirtualFile = this.createVirtualFile();
        }
        return this.myVirtualFile;
    }

    private VirtualFile createVirtualFile() {
        return new VcsVirtualFile(this.myPath, (VcsFileRevision)new ComparableVcsRevisionOnOperation(new GetFileContentOperation(this.getCvsLightFile(), this.myEnvironment, this.myEnvironment.getRevisionOrDate()), this.myProject), (VirtualFileSystem)VcsFileSystem.getInstance());
    }

    @Override
    public File getCvsLightFile() {
        return new File(((CvsElement)this.getParent()).createPathForChild(this.myName));
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getChildCount() {
        return 0;
    }
}

