/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ext;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionUtil;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.connections.ext.ExtLoginWorker;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProviderImpl;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionUtil;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.connection.IConnection;

public class ExtConnectionCvsSettings
extends CvsConnectionSettings {
    @NonNls
    public static final String UNCHANDLED_RESPONSE_PREFIX = "Unhandled response: ";
    private final SshSettings mySshSettings;

    public ExtConnectionCvsSettings(CvsRootConfiguration cvsRootConfiguration) {
        super(cvsRootConfiguration);
        this.mySshSettings = cvsRootConfiguration.SSH_FOR_EXT_CONFIGURATION;
    }

    @Override
    protected IConnection createOriginalConnection(ErrorRegistry errorRegistry, CvsRootConfiguration cvsRootConfiguration) {
        return CvsConnectionUtil.createExtConnection((CvsRootData)this, (ExtConfiguration)this.getExtConfiguration(), (SshSettings)this.mySshSettings, (SSHPasswordProvider)SSHPasswordProviderImpl.getInstance(), (ProxySettings)cvsRootConfiguration.PROXY_SETTINGS, (ErrorRegistry)errorRegistry, (int)(CvsApplicationLevelConfiguration.getInstance().TIMEOUT * 1000));
    }

    @Override
    public int getDefaultPort() {
        return 22;
    }

    public CvsLoginWorker getLoginWorker(ModalityContext executor, Project project) {
        return new MyLoginWorker(project, this, executor);
    }

    public CommandException processException(CommandException t) {
        Exception sourceException = t.getUnderlyingException();
        if (!(sourceException instanceof IOException)) {
            return t;
        }
        String localizedMessage = t.getLocalizedMessage();
        if (!localizedMessage.startsWith(UNCHANDLED_RESPONSE_PREFIX)) {
            return t;
        }
        String response = localizedMessage.substring(UNCHANDLED_RESPONSE_PREFIX.length(), localizedMessage.length() - 1);
        if (StringUtil.startsWithConcatenationOf((String)response, (String)(this.USER + "@"), (String)this.HOST)) {
            return new IOCommandException(new IOException(CvsBundle.message((String)"exception.text.ext.server.rejected.access", (Object[])new Object[0])));
        }
        return new IOCommandException(new IOException(CvsBundle.message((String)"exception.text.cannot.establish.external.connection", (Object[])new Object[]{response})));
    }

    private class MyLoginWorker
    implements CvsLoginWorker {
        private final CvsLoginWorker myWorker;
        private boolean mySshChecked;
        private final Project myProject;

        private MyLoginWorker(Project project, ExtConnectionCvsSettings settings, ModalityContext executor) {
            this.myProject = project;
            this.myWorker = new ExtLoginWorker(project, settings, executor);
        }

        public boolean promptForPassword() {
            if (!this.mySshChecked) {
                this.mySshChecked = true;
                return SshConnectionUtil.promptForPassword(ExtConnectionCvsSettings.this.mySshSettings, ExtConnectionCvsSettings.this.myStringRepsentation);
            }
            return this.myWorker.promptForPassword();
        }

        public ThreeState silentLogin(boolean forceCheck) {
            return this.myWorker.silentLogin(forceCheck);
        }

        public void goOffline() {
            this.myWorker.goOffline();
        }
    }
}

