/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.ConfigureCvsGlobalSettingsDialog;
import com.intellij.cvsSupport2.config.ui.Cvs2SettingsEditPanel;
import com.intellij.cvsSupport2.config.ui.CvsListCellRenderer;
import com.intellij.cvsSupport2.ui.CvsRootChangeListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CvsConfigurationsListEditor
extends DialogWrapper
implements DataProvider {
    private final BorderLayout myCenterPanelLayout = new BorderLayout();
    private final JPanel myCenterPanel = new JPanel(this.myCenterPanelLayout);
    private final JList myList = new JList();
    private final DefaultListModel myModel = new DefaultListModel();
    private CvsRootConfiguration mySelection;
    private final Cvs2SettingsEditPanel myCvs2SettingsEditPanel;
    @NonNls
    private static final String SAMPLE_CVSROOT = ":pserver:user@host/server/home/user/cvs";
    private boolean myIsReadOnly = false;

    public CvsConfigurationsListEditor(List<CvsRootConfiguration> configs, Project project) {
        super(true);
        this.myCvs2SettingsEditPanel = new Cvs2SettingsEditPanel(project);
        this.setTitle(CvsBundle.message((String)"operation.name.edit.configurations", (Object[])new Object[0]));
        this.myList.setSelectionMode(0);
        this.selectNone();
        this.fillModel(configs);
        this.myCvs2SettingsEditPanel.addCvsRootChangeListener(new CvsRootChangeListener(){

            @Override
            public void onCvsRootChanged() {
                if (CvsConfigurationsListEditor.this.mySelection == null) {
                    return;
                }
                CvsConfigurationsListEditor.this.myCvs2SettingsEditPanel.saveTo(CvsConfigurationsListEditor.this.mySelection, false);
                CvsConfigurationsListEditor.this.myList.repaint();
            }
        });
        this.setTitle(CvsBundle.message((String)"dialog.title.cvs.roots", (Object[])new Object[0]));
        if (!configs.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
        this.init();
    }

    @Nullable
    public static CvsRootConfiguration reconfigureCvsRoot(String root, Project project) {
        CvsApplicationLevelConfiguration configuration = CvsApplicationLevelConfiguration.getInstance();
        CvsRootConfiguration selectedConfig = configuration.getConfigurationForCvsRoot(root);
        ArrayList<CvsRootConfiguration> modifiableList = new ArrayList<CvsRootConfiguration>(configuration.CONFIGURATIONS);
        CvsConfigurationsListEditor editor = new CvsConfigurationsListEditor(modifiableList, project);
        editor.select(selectedConfig);
        editor.setReadOnly();
        editor.show();
        if (editor.isOK()) {
            configuration.CONFIGURATIONS = modifiableList;
            return configuration.getConfigurationForCvsRoot(root);
        }
        return null;
    }

    private void setReadOnly() {
        this.myIsReadOnly = true;
        this.myList.setEnabled(false);
        this.myCvs2SettingsEditPanel.setReadOnly();
    }

    protected Action[] createLeftSideActions() {
        AbstractAction globalSettingsAction = new AbstractAction(CvsBundle.message((String)"button.text.global.settings", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ConfigureCvsGlobalSettingsDialog().show();
            }
        };
        return new Action[]{globalSettingsAction};
    }

    protected void doOKAction() {
        if (this.saveSelectedConfiguration()) {
            super.doOKAction();
        }
    }

    private void fillModel(List<CvsRootConfiguration> configurations) {
        for (CvsRootConfiguration configuration : configurations) {
            this.myModel.addElement(configuration.getMyCopy());
        }
    }

    private JComponent createListPanel() {
        return ScrollPaneFactory.createScrollPane((JComponent)this.myList);
    }

    private JPanel createActionsPanel() {
        DefaultActionGroup commonActionGroup = new DefaultActionGroup();
        commonActionGroup.add((AnAction)new MyAddAction());
        commonActionGroup.add((AnAction)new MyRemoveAction());
        commonActionGroup.add((AnAction)new MyCopyAction());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("CvsConfigurationsToolbar", (ActionGroup)commonActionGroup, true);
        JPanel actionPanel = new JPanel(new BorderLayout());
        actionPanel.add((Component)actionToolbar.getComponent(), "West");
        return actionPanel;
    }

    protected JComponent createCenterPanel() {
        this.myList.setCellRenderer(new CvsListCellRenderer());
        this.myCenterPanelLayout.setHgap(6);
        this.myCenterPanel.add((Component)this.createActionsPanel(), "North");
        JComponent listPanel = this.createListPanel();
        this.myCenterPanel.add((Component)listPanel, "Center");
        this.myCenterPanel.add((Component)this.createCvsConfigurationPanel(), "East");
        this.myCenterPanel.add((Component)new JSeparator(0), "South");
        this.myList.setModel(this.myModel);
        this.addSelectionListener();
        int minWidth = this.myList.getFontMetrics(this.myList.getFont()).stringWidth(SAMPLE_CVSROOT) + 40;
        Dimension minSize = new Dimension(minWidth, this.myList.getMaximumSize().height);
        listPanel.setMinimumSize(minSize);
        listPanel.setPreferredSize(minSize);
        return this.myCenterPanel;
    }

    private JComponent createCvsConfigurationPanel() {
        return this.myCvs2SettingsEditPanel.getPanel();
    }

    private boolean saveSelectedConfiguration() {
        if (this.getSelectedConfiguration() == null) {
            return true;
        }
        return this.myCvs2SettingsEditPanel.saveTo(this.getSelectedConfiguration(), true);
    }

    private void copySelectedConfiguration() {
        if (!this.saveSelectedConfiguration()) {
            return;
        }
        CvsRootConfiguration newConfig = this.mySelection.getMyCopy();
        this.myModel.addElement(newConfig);
        this.myList.setSelectedValue(newConfig, true);
    }

    private void editSelectedConfiguration() {
        this.editConfiguration(this.mySelection);
        this.myList.repaint();
    }

    private void removeSelectedConfiguration() {
        int newSelection;
        int oldSelection = this.myList.getSelectedIndex();
        this.myModel.removeElement(this.mySelection);
        int size = this.myList.getModel().getSize();
        int n = newSelection = oldSelection < size ? oldSelection : size - 1;
        if (newSelection >= 0 && newSelection < size) {
            this.myList.setSelectedIndex(newSelection);
        }
    }

    private void createNewConfiguration() {
        if (!this.saveSelectedConfiguration()) {
            return;
        }
        this.myList.setSelectedValue(null, false);
        CvsRootConfiguration newConfig = CvsApplicationLevelConfiguration.createNewConfiguration(CvsApplicationLevelConfiguration.getInstance());
        this.myModel.addElement(newConfig);
        this.myList.setSelectedValue(newConfig, true);
    }

    private void editConfiguration(CvsRootConfiguration newConfig) {
        this.myCvs2SettingsEditPanel.updateFrom(newConfig);
    }

    private void addSelectionListener() {
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = CvsConfigurationsListEditor.this.myList.getSelectedIndex();
                if (selectedIndex < 0 || selectedIndex >= CvsConfigurationsListEditor.this.myModel.getSize()) {
                    CvsConfigurationsListEditor.this.selectNone();
                } else {
                    CvsRootConfiguration newSelection = (CvsRootConfiguration)CvsConfigurationsListEditor.this.myModel.getElementAt(selectedIndex);
                    if (newSelection == CvsConfigurationsListEditor.this.mySelection) {
                        return;
                    }
                    if (!CvsConfigurationsListEditor.this.select(newSelection)) {
                        CvsConfigurationsListEditor.this.myList.setSelectedValue(CvsConfigurationsListEditor.this.mySelection, true);
                    }
                }
            }
        });
    }

    private boolean select(CvsRootConfiguration cvs2Configuration) {
        if (this.mySelection != null && !this.myCvs2SettingsEditPanel.saveTo(this.mySelection, true)) {
            return false;
        }
        this.mySelection = cvs2Configuration;
        this.editSelectedConfiguration();
        return true;
    }

    private void selectNone() {
        this.myCvs2SettingsEditPanel.disable();
        this.mySelection = null;
    }

    public ArrayList<CvsRootConfiguration> getConfigurations() {
        ArrayList<CvsRootConfiguration> result = new ArrayList<CvsRootConfiguration>();
        Enumeration each = this.myModel.elements();
        while (each.hasMoreElements()) {
            result.add((CvsRootConfiguration)each.nextElement());
        }
        return result;
    }

    public CvsRootConfiguration getSelectedConfiguration() {
        return this.mySelection;
    }

    public void selectConfiguration(CvsRootConfiguration selectedConfiguration) {
        this.myList.setSelectedValue(selectedConfiguration, true);
    }

    @NonNls
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.versionControl.cvs.options";
        }
        return null;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.versionControl.cvs.options");
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myModel.isEmpty()) {
            return null;
        }
        return this.myCvs2SettingsEditPanel.getPreferredFocusedComponent();
    }

    private class MyCopyAction
    extends AnAction {
        public MyCopyAction() {
            super(CvsBundle.message((String)"action.name.copy", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/general/copy.png"));
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(67, SystemInfo.isMac ? 4 : 2)), CvsConfigurationsListEditor.this.myList);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(CvsConfigurationsListEditor.this.getSelectedConfiguration() != null && !CvsConfigurationsListEditor.this.myIsReadOnly);
        }

        public void actionPerformed(AnActionEvent e) {
            CvsConfigurationsListEditor.this.copySelectedConfiguration();
        }
    }

    private class MyRemoveAction
    extends AnAction {
        public MyRemoveAction() {
            super(CvsBundle.message((String)"action.name.remove", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/general/remove.png"));
            this.registerCustomShortcutSet(CommonShortcuts.DELETE, CvsConfigurationsListEditor.this.myList);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(CvsConfigurationsListEditor.this.getSelectedConfiguration() != null && !CvsConfigurationsListEditor.this.myIsReadOnly);
        }

        public void actionPerformed(AnActionEvent e) {
            CvsConfigurationsListEditor.this.removeSelectedConfiguration();
        }
    }

    private class MyAddAction
    extends AnAction {
        public MyAddAction() {
            super(CvsBundle.message((String)"action.name.add", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/general/add.png"));
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, CvsConfigurationsListEditor.this.myList);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!CvsConfigurationsListEditor.this.myIsReadOnly);
        }

        public void actionPerformed(AnActionEvent e) {
            CvsConfigurationsListEditor.this.createNewConfiguration();
        }
    }
}

