/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.changeBrowser.CvsChangeList;
import com.intellij.cvsSupport2.changeBrowser.CvsChangeListsBuilder;
import com.intellij.cvsSupport2.changeBrowser.CvsRepositoryLocation;
import com.intellij.cvsSupport2.changeBrowser.CvsVersionFilterComponent;
import com.intellij.cvsSupport2.changeBrowser.LoadHistoryOperation;
import com.intellij.cvsSupport2.changeBrowser.LogInformationWrapper;
import com.intellij.cvsSupport2.changeBrowser.RevisionWrapper;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipperAdapter;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsCommittedChangesProvider
implements CachingCommittedChangesProvider<CvsChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.changeBrowser.CvsCommittedChangesProvider");
    private final Project myProject;
    private final MyZipper myZipper;
    @NonNls
    private static final String INVALID_OPTION_S = "invalid option -- S";
    private final ChangeListColumn<CvsChangeList> BRANCH_COLUMN = new ChangeListColumn<CvsChangeList>(){

        public String getTitle() {
            return CvsBundle.message((String)"changelist.column.branch", (Object[])new Object[0]);
        }

        public Object getValue(CvsChangeList changeList) {
            String branch = changeList.getBranch();
            return branch == null ? "HEAD" : branch;
        }
    };

    public CvsCommittedChangesProvider(Project project) {
        this.myProject = project;
        this.myZipper = new MyZipper();
    }

    public ChangeBrowserSettings createDefaultSettings() {
        return new ChangeBrowserSettings();
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new CvsVersionFilterComponent(showDateFilter);
    }

    public VcsCommittedListsZipper getZipper() {
        return this.myZipper;
    }

    @Nullable
    public CvsRepositoryLocation getLocationFor(FilePath root) {
        if (!CvsUtil.fileIsUnderCvs(root.getIOFile())) {
            return null;
        }
        VirtualFile rootDir = root.isDirectory() ? root.getVirtualFile() : root.getVirtualFileParent();
        String module = CvsUtil.getModuleName(root);
        CvsConnectionSettings connectionSettings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(rootDir);
        return new CvsRepositoryLocation(root.getVirtualFile(), connectionSettings, module);
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{ChangeListColumn.DATE, ChangeListColumn.NAME, ChangeListColumn.DESCRIPTION, this.BRANCH_COLUMN};
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        return null;
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    public List<CvsChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        CvsRepositoryLocation cvsLocation = (CvsRepositoryLocation)location;
        return this.loadCommittedChanges(settings, cvsLocation.getModuleName(), cvsLocation.getEnvironment(), cvsLocation.getRootFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            ChangeBrowserSettings.Filter filter;
            HashSet controlSet;
            CvsResult executionResult;
            CvsRepositoryLocation cvsLocation = (CvsRepositoryLocation)location;
            String module = cvsLocation.getModuleName();
            CvsEnvironment connectionSettings = cvsLocation.getEnvironment();
            if (connectionSettings.isOffline()) {
                return;
            }
            final CvsChangeListsBuilder builder = new CvsChangeListsBuilder(module, connectionSettings, this.myProject, cvsLocation.getRootFile());
            Date dateTo = settings.getDateBeforeFilter();
            Date dateFrom = settings.getDateAfterFilter();
            if (dateFrom == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1970, 2, 2);
                dateFrom = calendar.getTime();
            }
            if ((executionResult = this.runRLogOperation(connectionSettings, module, dateFrom, dateTo, new Consumer<LogInformationWrapper>(controlSet = new HashSet(), filter = settings.createFilter(), consumer){
                final /* synthetic */ Set val$controlSet;
                final /* synthetic */ ChangeBrowserSettings.Filter val$filter;
                final /* synthetic */ AsynchConsumer val$consumer;
                {
                    this.val$controlSet = set;
                    this.val$filter = filter;
                    this.val$consumer = asynchConsumer;
                }

                public void consume(LogInformationWrapper wrapper) {
                    List<RevisionWrapper> wrappers = builder.revisionWrappersFromLog(wrapper);
                    if (wrappers != null) {
                        for (RevisionWrapper revisionWrapper : wrappers) {
                            CvsChangeList changeList = builder.addRevision(revisionWrapper);
                            if (this.val$controlSet.contains(changeList.getCommitDate())) continue;
                            this.val$controlSet.add(changeList.getCommitDate());
                            if (!this.val$filter.accepts((CommittedChangeList)changeList)) continue;
                            this.val$consumer.consume((Object)changeList);
                        }
                    }
                }
            })).isCanceled()) {
                throw new ProcessCanceledException();
            }
            if (!executionResult.hasNoErrors()) {
                throw executionResult.composeError();
            }
        }
        finally {
            consumer.finished();
        }
    }

    private List<CvsChangeList> loadCommittedChanges(ChangeBrowserSettings settings, String module, CvsEnvironment connectionSettings, VirtualFile rootFile) throws VcsException {
        ArrayList<LogInformationWrapper> log;
        CvsResult executionResult;
        if (connectionSettings.isOffline()) {
            return Collections.emptyList();
        }
        CvsChangeListsBuilder builder = new CvsChangeListsBuilder(module, connectionSettings, this.myProject, rootFile);
        Date dateTo = settings.getDateBeforeFilter();
        Date dateFrom = settings.getDateAfterFilter();
        if (dateFrom == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1970, 2, 2);
            dateFrom = calendar.getTime();
        }
        if ((executionResult = this.runRLogOperation(connectionSettings, module, dateFrom, dateTo, log = new ArrayList<LogInformationWrapper>())).isCanceled()) {
            throw new ProcessCanceledException();
        }
        if (!executionResult.hasNoErrors()) {
            throw executionResult.composeError();
        }
        builder.addLogs(log);
        List<CvsChangeList> versions = builder.getVersions();
        settings.filterChanges(versions);
        return versions;
    }

    private CvsResult runRLogOperation(CvsEnvironment settings, String module, Date dateFrom, Date dateTo, Consumer<LogInformationWrapper> consumer) {
        CvsResult executionResult = this.runRLogOperationImpl(settings, module, dateFrom, dateTo, consumer);
        for (VcsException error : executionResult.getErrors()) {
            for (String message : error.getMessages()) {
                if (message.indexOf(INVALID_OPTION_S) < 0) continue;
                LoadHistoryOperation.doesNotSuppressEmptyHeaders(settings);
                return this.runRLogOperationImpl(settings, module, dateFrom, dateTo, consumer);
            }
        }
        return executionResult;
    }

    private CvsResult runRLogOperationImpl(CvsEnvironment settings, String module, Date dateFrom, Date dateTo, final Consumer<LogInformationWrapper> consumer) {
        LoadHistoryOperation operation = new LoadHistoryOperation(settings, module, dateFrom, dateTo, null){

            @Override
            protected void wrapperAdded(LogInformationWrapper wrapper) {
                consumer.consume((Object)wrapper);
            }
        };
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(new CommandCvsHandler(CvsBundle.message((String)"browse.changes.load.history.progress.title", (Object[])new Object[0]), operation), CvsOperationExecutorCallback.EMPTY);
        return executor.getResult();
    }

    private CvsResult runRLogOperation(CvsEnvironment settings, String module, Date dateFrom, Date dateTo, List<LogInformationWrapper> log) {
        LoadHistoryOperation operation = new LoadHistoryOperation(settings, module, dateFrom, dateTo, log);
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(new CommandCvsHandler(CvsBundle.message((String)"browse.changes.load.history.progress.title", (Object[])new Object[0]), operation), CvsOperationExecutorCallback.EMPTY);
        CvsResult executionResult = executor.getResult();
        for (VcsException error : executionResult.getErrors()) {
            for (String message : error.getMessages()) {
                if (message.indexOf(INVALID_OPTION_S) < 0) continue;
                LoadHistoryOperation.doesNotSuppressEmptyHeaders(settings);
                log.clear();
                return this.runRLogOperation(settings, module, dateFrom, dateTo, log);
            }
        }
        return executionResult;
    }

    public int getFormatVersion() {
        return 2;
    }

    public void writeChangeList(DataOutput stream, CvsChangeList list) throws IOException {
        list.writeToStream(stream);
    }

    public CvsChangeList readChangeList(RepositoryLocation location, DataInput stream) throws IOException {
        CvsRepositoryLocation cvsLocation = (CvsRepositoryLocation)location;
        return new CvsChangeList(this.myProject, cvsLocation.getEnvironment(), cvsLocation.getRootFile(), stream);
    }

    public boolean isMaxCountSupported() {
        return false;
    }

    public Collection<FilePath> getIncomingFiles(RepositoryLocation location) {
        return null;
    }

    public boolean refreshCacheByNumber() {
        return false;
    }

    public String getChangelistTitle() {
        return null;
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, CvsChangeList changeList) {
        if (localRevision instanceof CvsRevisionNumber && changeRevision instanceof CvsRevisionNumber) {
            CvsRevisionNumber cvsLocalRevision = (CvsRevisionNumber)localRevision;
            CvsRevisionNumber cvsChangeRevision = (CvsRevisionNumber)changeRevision;
            int[] localSubRevisions = cvsLocalRevision.getSubRevisions();
            int[] changeSubRevisions = cvsChangeRevision.getSubRevisions();
            if (localSubRevisions != null && changeSubRevisions != null) {
                if (localSubRevisions.length != changeSubRevisions.length) {
                    return true;
                }
                for (int i = 2; i < localSubRevisions.length; i += 2) {
                    if (localSubRevisions[i] == changeSubRevisions[i]) continue;
                    return true;
                }
            }
        }
        return CvsCommittedChangesProvider.isDifferentBranch(filePath, changeList) || localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    private static boolean isDifferentBranch(final FilePath filePath, CvsChangeList changeList) {
        String localTag;
        CvsEntriesManager cvsEntriesManager = CvsEntriesManager.getInstance();
        VirtualFile parent = filePath.getVirtualFileParent();
        if (parent != null) {
            Entry entry = cvsEntriesManager.getEntryFor(parent, filePath.getName());
            localTag = entry != null ? entry.getStickyTag() : CvsCommittedChangesProvider.getDirectoryTag(parent);
        } else {
            VirtualFile validParent = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

                @Nullable
                public VirtualFile compute() {
                    return ChangesUtil.findValidParent((FilePath)filePath);
                }
            });
            if (validParent == null) {
                return false;
            }
            localTag = CvsCommittedChangesProvider.getDirectoryTag(validParent);
        }
        String remoteTag = changeList.getBranch();
        if (!Comparing.equal((String)localTag, (String)remoteTag)) {
            LOG.info(filePath + ": local tag " + localTag + ", remote tag " + remoteTag);
            return true;
        }
        return false;
    }

    @Nullable
    private static String getDirectoryTag(@NotNull VirtualFile parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/changeBrowser/CvsCommittedChangesProvider.getDirectoryTag must not be null");
        }
        String dirTag = CvsEntriesManager.getInstance().getCvsInfoFor(parent).getStickyTag();
        if (dirTag == null || !CvsUtil.isNonDateTag(dirTag)) {
            return null;
        }
        return dirTag.substring(1);
    }

    public boolean refreshIncomingWithCommitted() {
        return true;
    }

    private class MyZipper
    extends VcsCommittedListsZipperAdapter {
        private MyZipper() {
            super(new VcsCommittedListsZipperAdapter.GroupCreator(){

                public Object createKey(RepositoryLocation location) {
                    CvsRepositoryLocation cvsLocation = (CvsRepositoryLocation)location;
                    return cvsLocation.getEnvironment().getRepository();
                }

                public RepositoryLocationGroup createGroup(Object key, Collection<RepositoryLocation> locations) {
                    RepositoryLocationGroup group = new RepositoryLocationGroup((String)key);
                    for (RepositoryLocation location : locations) {
                        group.add(location);
                    }
                    return group;
                }
            });
        }

        public long getNumber(CommittedChangeList list) {
            return list.getCommitDate().getTime();
        }
    }
}

