/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.merge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public class CvsConflictsParser {
    private static final String RIGHT = "<<<<<<<";
    private static final String LEFT = "=======";
    private static final String END = ">>>>>>>";
    private final StringBuffer myLeftBuffer = new StringBuffer();
    private final StringBuffer myCenterBuffer = new StringBuffer();
    private final StringBuffer myRightBuffer = new StringBuffer();
    private final Stack<State> myStateStack = new Stack();

    public String getLeftVersion() {
        return this.myLeftBuffer.toString();
    }

    public String getCenterVersion() {
        return this.myCenterBuffer.toString();
    }

    public String getRightVersion() {
        return this.myRightBuffer.toString();
    }

    private CvsConflictsParser() {
    }

    public static CvsConflictsParser createOn(InputStream merged) throws IOException {
        CvsConflictsParser result = new CvsConflictsParser();
        result.parseFile(merged);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(InputStream merged) throws IOException {
        InputStreamReader isr = new InputStreamReader(merged);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String cutLine = this.findMarkerAndWriteTail(line, RIGHT);
                if (cutLine != null) {
                    this.processRightMarker(cutLine);
                    continue;
                }
                cutLine = this.findMarkerAndWriteTail(line, LEFT);
                if (cutLine != null) {
                    this.processLeftMarker(cutLine);
                    continue;
                }
                cutLine = this.findMarkerAndWriteTail(line, END);
                if (cutLine != null) {
                    this.processEndMarker(cutLine);
                    continue;
                }
                this.appendToMainOrCurrent(line);
            }
        }
        finally {
            br.close();
        }
    }

    private void appendToMainOrCurrent(String line) {
        if (this.myStateStack.isEmpty()) {
            this.appendLine(line);
        } else {
            this.appendToCurrentBuffer(line);
        }
    }

    @Nullable
    private String findMarkerAndWriteTail(String s, String marker) {
        int idx = s.indexOf(marker);
        if (idx == -1) {
            return null;
        }
        String startFragment = s.substring(0, idx);
        if (startFragment.length() > 0) {
            this.appendToMainOrCurrent(startFragment);
        }
        return s.substring(idx);
    }

    private void processEndMarker(String line) {
        if (this.myStateStack.isEmpty()) {
            this.appendLine(line);
        } else {
            this.myStateStack.pop();
            if (!this.myStateStack.isEmpty()) {
                this.appendToCurrentBuffer(line);
            }
        }
    }

    private void processLeftMarker(String line) {
        if (this.myStateStack.isEmpty()) {
            this.appendLine(line);
        } else if (this.myStateStack.peek() == State.LEFT) {
            this.myStateStack.pop();
            this.myStateStack.push(State.RIGHT);
            if (this.myStateStack.size() > 1) {
                this.appendToCurrentBuffer(line);
            }
        } else {
            this.appendToCurrentBuffer(line);
        }
    }

    private void processRightMarker(String line) {
        if (this.myStateStack.isEmpty()) {
            this.myStateStack.push(State.LEFT);
        } else {
            this.myStateStack.push(State.LEFT);
            this.appendToCurrentBuffer(line);
        }
    }

    private void appendToCurrentBuffer(String line) {
        if (this.myStateStack.get(0) == State.RIGHT) {
            CvsConflictsParser.appendLine(line, this.myRightBuffer);
        } else {
            CvsConflictsParser.appendLine(line, this.myLeftBuffer);
        }
    }

    private void appendLine(String line) {
        CvsConflictsParser.appendLine(line, this.myLeftBuffer);
        CvsConflictsParser.appendLine(line, this.myCenterBuffer);
        CvsConflictsParser.appendLine(line, this.myRightBuffer);
    }

    private static void appendLine(String line, StringBuffer buffer) {
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append(line);
    }

    static enum State {
        RIGHT,
        LEFT;

    }
}

