/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.AbstractAction;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.SelectCvsConfigurationDialog;
import com.intellij.cvsSupport2.cvsBrowser.ui.BrowserPanel;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvshandlers.AbstractCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.cvsSupport2.cvsoperations.common.LoginPerformer;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.util.Consumer;
import java.util.Collections;

public class BrowseCvsRepositoryAction
extends AbstractAction
implements DumbAware {
    private static final String TITLE = CvsBundle.message((String)"operation.name.browse.repository", (Object[])new Object[0]);
    private CvsRootConfiguration mySelectedConfiguration;

    public BrowseCvsRepositoryAction() {
        super(false);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        CvsContext context = CvsContextWrapper.createInstance(e);
        boolean projectExists = context.getProject() != null;
        presentation.setVisible(true);
        presentation.setEnabled(projectExists);
    }

    @Override
    protected String getTitle(VcsContext context) {
        return TITLE;
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        SelectCvsConfigurationDialog selectCvsConfigurationDialog = new SelectCvsConfigurationDialog(context.getProject());
        selectCvsConfigurationDialog.show();
        if (!selectCvsConfigurationDialog.isOK()) {
            return CvsHandler.NULL;
        }
        this.mySelectedConfiguration = selectCvsConfigurationDialog.getSelectedConfiguration();
        return new MyCvsHandler(context.getProject());
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        if (this.mySelectedConfiguration == null) {
            return;
        }
        if (!this.loginImpl(context.getProject(), new ModalityContextImpl(ModalityState.NON_MODAL, false), new Consumer<VcsException>(){

            public void consume(VcsException e) {
            }
        })) {
            return;
        }
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        if (successfully) {
            Project project = context.getProject();
            LOG.assertTrue(project != null);
            LOG.assertTrue(this.mySelectedConfiguration != null);
            BrowserPanel browserPanel = new BrowserPanel(this.mySelectedConfiguration, project);
            tabbedWindow.addTab(TITLE, browserPanel, true, true, true, true, browserPanel.getActionGroup(), "cvs.browse");
            tabbedWindow.ensureVisible(project);
        }
    }

    public boolean loginImpl(Project project, ModalityContext executor, Consumer<VcsException> exceptionConsumer) {
        LoginPerformer.MyProjectKnown performer = new LoginPerformer.MyProjectKnown(project, Collections.singletonList(this.mySelectedConfiguration), exceptionConsumer);
        return performer.loginAll(executor, false);
    }

    private class MyCvsHandler
    extends AbstractCvsHandler {
        private final Project myProject;

        public MyCvsHandler(Project project) {
            super(TITLE, FileSetToBeUpdated.EMPTY);
            this.myProject = project;
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        protected int getFilesToProcessCount() {
            return 0;
        }

        @Override
        public boolean login(ModalityContext executor) throws Exception {
            return BrowseCvsRepositoryAction.this.loginImpl(this.myProject, executor, new Consumer<VcsException>(){

                public void consume(VcsException e) {
                    MyCvsHandler.this.myErrors.add(e);
                }
            });
        }
    }
}

