/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.run.PluginRunConfiguration;

public class PluginConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            PluginRunConfiguration runConfiguration = new PluginRunConfiguration(project, this, "");
            runConfiguration.VM_PARAMETERS = runConfiguration.VM_PARAMETERS == null ? PluginConfigurationType.this.getVmParameters() : runConfiguration.VM_PARAMETERS + PluginConfigurationType.this.getVmParameters();
            return runConfiguration;
        }

        public RunConfiguration createConfiguration(String name, RunConfiguration template) {
            Module[] modules;
            PluginRunConfiguration pluginRunConfiguration = (PluginRunConfiguration)template;
            if (pluginRunConfiguration.getModule() == null && (modules = pluginRunConfiguration.getModules()) != null && modules.length > 0) {
                pluginRunConfiguration.setModule(modules[0]);
            }
            return super.createConfiguration(name, (RunConfiguration)pluginRunConfiguration);
        }
    };
    private String myVmParameters;
    private static final Icon ICON = IconLoader.getIcon((String)"/nodes/plugin.png");

    PluginConfigurationType() {
    }

    public String getDisplayName() {
        return DevKitBundle.message("run.configuration.title", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return DevKitBundle.message("run.configuration.type.description", new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        if ("#org.jetbrains.idea.devkit.run.PluginConfigurationType" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/run/PluginConfigurationType.getId must not return null");
        }
        return "#org.jetbrains.idea.devkit.run.PluginConfigurationType";
    }

    public String getVmParameters() {
        if (this.myVmParameters == null) {
            this.myVmParameters = "";
            String vmParameters = PluginConfigurationType.readFile("idea.plugins.vmoptions");
            if (vmParameters != null) {
                this.myVmParameters = vmParameters;
            } else {
                vmParameters = PluginConfigurationType.readFile("idea.exe.vmoptions");
                if (vmParameters != null) {
                    this.myVmParameters = vmParameters;
                }
            }
        }
        return this.myVmParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String readFile(@NonNls String fileName) {
        File file = new File(PathManager.getBinPath(), fileName);
        if (file.exists()) {
            StringBuffer lines = new StringBuffer();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    lines.append(" ").append(line);
                }
            }
            catch (IOException e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
            return lines.toString();
        }
        return null;
    }
}

