/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

public class GenerateComponentExternalizationAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.actions.GenerateComponentExternalizationAction");
    @NonNls
    private static final String BASE_COMPONENT = "com.intellij.openapi.components.BaseComponent";
    @NonNls
    private static final String JDOM_EXTERN = "com.intellij.openapi.util.JDOMExternalizable";

    public void actionPerformed(AnActionEvent e) {
        final PsiClass target = this.getComponentInContext(e.getDataContext());
        assert (target != null);
        final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)target.getProject()).getElementFactory();
        final CodeStyleManager formatter = target.getManager().getCodeStyleManager();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiReferenceList implList = target.getImplementsList();
                            assert (implList != null);
                            implList.add((PsiElement)factory.createReferenceElementByFQClassName(GenerateComponentExternalizationAction.JDOM_EXTERN, target.getResolveScope()));
                            PsiMethod read = factory.createMethodFromText("public void readExternal(org.jdom.Element element) throws com.intellij.openapi.util.InvalidDataException { com.intellij.openapi.util.DefaultJDOMExternalizer.readExternal(this, element); }", (PsiElement)target);
                            read = (PsiMethod)formatter.reformat(target.add((PsiElement)read));
                            JavaCodeStyleManager styler = JavaCodeStyleManager.getInstance((Project)target.getProject());
                            styler.shortenClassReferences((PsiElement)read);
                            PsiMethod write = factory.createMethodFromText("public void writeExternal(org.jdom.Element element) throws com.intellij.openapi.util.WriteExternalException { com.intellij.openapi.util.DefaultJDOMExternalizer.writeExternal(this, element); }", (PsiElement)target);
                            write = (PsiMethod)formatter.reformat(target.add((PsiElement)write));
                            styler.shortenClassReferences((PsiElement)write);
                        }
                        catch (IncorrectOperationException e1) {
                            LOG.error((Throwable)e1);
                        }
                    }
                });
            }
        };
        CommandProcessor.getInstance().executeCommand(target.getProject(), runnable, DevKitBundle.message("command.implement.externalizable", new Object[0]), null);
    }

    @Nullable
    private PsiClass getComponentInContext(DataContext context) {
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(context);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
        if (editor == null || project == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(context);
        if (file == null) {
            return null;
        }
        PsiClass contextClass = (PsiClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PsiClass.class, (boolean)false);
        if (contextClass == null || contextClass.isEnum() || contextClass.isInterface() || contextClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass componentClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(BASE_COMPONENT, file.getResolveScope());
        if (componentClass == null || !contextClass.isInheritor(componentClass, true)) {
            return null;
        }
        PsiClass externClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(JDOM_EXTERN, file.getResolveScope());
        if (externClass == null || contextClass.isInheritor(externClass, true)) {
            return null;
        }
        return contextClass;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        PsiClass target = this.getComponentInContext(e.getDataContext());
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(target != null);
        presentation.setVisible(target != null);
    }
}

