/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class LightBulbComponentImpl
extends JComponent {
    private final QuickFixManager myManager;
    private final Icon myIcon;

    public LightBulbComponentImpl(@NotNull QuickFixManager manager, @NotNull Icon icon) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/quickFixes/LightBulbComponentImpl.<init> must not be null");
        }
        if (icon == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/quickFixes/LightBulbComponentImpl.<init> must not be null");
        }
        this.myManager = manager;
        this.myIcon = icon;
        this.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (acceleratorsText.length() > 0) {
            this.setToolTipText(UIDesignerBundle.message("tooltip.press.accelerator", acceleratorsText));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LightBulbComponentImpl.this.myManager.showIntentionPopup();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.myIcon.paintIcon(this, g, 0, 0);
    }
}

