/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.text.MessageFormat;

public class ChangeFieldTypeFix
extends QuickFix {
    private final PsiField myField;
    private final PsiType myNewType;

    public ChangeFieldTypeFix(GuiEditor uiEditor, PsiField field, PsiType uiComponentType) {
        super(uiEditor, MessageFormat.format(UIDesignerBundle.message("action.change.field.type", new Object[0]), field.getName(), field.getType().getCanonicalText(), uiComponentType.getCanonicalText()), null);
        this.myField = field;
        this.myNewType = uiComponentType;
    }

    @Override
    public void run() {
        ReadonlyStatusHandler roHandler = ReadonlyStatusHandler.getInstance((Project)this.myField.getProject());
        PsiFile psiFile = this.myField.getContainingFile();
        if (psiFile == null) {
            return;
        }
        ReadonlyStatusHandler.OperationStatus status = roHandler.ensureFilesWritable(new VirtualFile[]{psiFile.getVirtualFile()});
        if (status.hasReadonlyFiles()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(ChangeFieldTypeFix.this.myField.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiManager manager = ChangeFieldTypeFix.this.myField.getManager();
                            ChangeFieldTypeFix.this.myField.getTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeElement(ChangeFieldTypeFix.this.myNewType));
                        }
                        catch (IncorrectOperationException e) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showErrorDialog((Component)ChangeFieldTypeFix.this.myEditor, (String)UIDesignerBundle.message("error.cannot.change.field.type", ChangeFieldTypeFix.this.myField.getName(), e.getMessage()), (String)CommonBundle.getErrorTitle());
                                }
                            });
                        }
                    }
                }, ChangeFieldTypeFix.this.getName(), null);
            }
        });
    }
}

