/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.projectView.Form;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class FormNode
extends ProjectViewNode<Form> {
    private final Collection<BasePsiNode<? extends PsiElement>> myChildren;

    public FormNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (Form)value, viewSettings, FormNode.getChildren(project, (Form)value, viewSettings));
    }

    public FormNode(Project project, Form value, ViewSettings viewSettings, Collection<BasePsiNode<? extends PsiElement>> children) {
        super(project, (Object)value, viewSettings);
        this.myChildren = children;
    }

    @NotNull
    public Collection<BasePsiNode<? extends PsiElement>> getChildren() {
        Collection<BasePsiNode<? extends PsiElement>> collection = this.myChildren;
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/projectView/FormNode.getChildren must not return null");
        }
        return collection;
    }

    public String getTestPresentation() {
        return "Form:" + ((Form)this.getValue()).getName();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/projectView/FormNode.contains must not be null");
        }
        for (BasePsiNode<? extends PsiElement> aMyChildren : this.myChildren) {
            ProjectViewNode treeNode = (ProjectViewNode)aMyChildren;
            if (!treeNode.contains(file)) continue;
            return true;
        }
        return false;
    }

    public void update(PresentationData presentation) {
        if (this.getValue() == null || !((Form)this.getValue()).isValid()) {
            this.setValue(null);
        } else {
            presentation.setPresentableText(((Form)this.getValue()).getName());
            presentation.setIcons(StdFileTypes.GUI_DESIGNER_FORM.getIcon());
        }
    }

    public void navigate(boolean requestFocus) {
        ((Form)this.getValue()).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((Form)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((Form)this.getValue()).canNavigateToSource();
    }

    public String getToolTip() {
        return IdeBundle.message((String)"tooltip.ui.designer.form", (Object[])new Object[0]);
    }

    public FileStatus getFileStatus() {
        for (BasePsiNode<? extends PsiElement> child : this.myChildren) {
            FileStatus fileStatus;
            PsiElement value = (PsiElement)child.getValue();
            if (value == null || !value.isValid() || (fileStatus = child.getFileStatus()) == FileStatus.NOT_CHANGED) continue;
            return fileStatus;
        }
        return FileStatus.NOT_CHANGED;
    }

    public boolean canHaveChildrenMatching(Condition<PsiFile> condition) {
        for (BasePsiNode<? extends PsiElement> child : this.myChildren) {
            if (!condition.value((Object)((PsiElement)child.getValue()).getContainingFile())) continue;
            return true;
        }
        return false;
    }

    public static AbstractTreeNode constructFormNode(PsiClass classToBind, Project project, ViewSettings settings) {
        Form form = new Form(classToBind);
        Collection<BasePsiNode<? extends PsiElement>> children = FormNode.getChildren(project, form, settings);
        return new FormNode(project, form, settings, children);
    }

    private static Collection<BasePsiNode<? extends PsiElement>> getChildren(Project project, Form form, ViewSettings settings) {
        LinkedHashSet<BasePsiNode<? extends PsiElement>> children = new LinkedHashSet<BasePsiNode<? extends PsiElement>>();
        children.add((BasePsiNode<? extends PsiElement>)new ClassTreeNode(project, form.getClassToBind(), settings));
        for (PsiFile formBoundToClass : form.getFormFiles()) {
            children.add((BasePsiNode<? extends PsiElement>)new PsiFileNode(project, formBoundToClass, settings));
        }
        return children;
    }
}

