/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.uiDesigner.ErrorAnalyzer;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class QuickFixManagerImpl
extends QuickFixManager<ComponentTree> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.componentTree.QuickFixManagerImpl");

    public QuickFixManagerImpl(GuiEditor editor, @NotNull ComponentTree componentTree, JViewport viewPort) {
        if (componentTree == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/componentTree/QuickFixManagerImpl.<init> must not be null");
        }
        super(editor, componentTree, viewPort);
        ((ComponentTree)((Object)this.myComponent)).addTreeSelectionListener(new MyTreeSelectionListener());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected ErrorInfo[] getErrorInfos() {
        ErrorInfo[] errorInfoArray;
        RadComponent component = ((ComponentTree)((Object)this.myComponent)).getSelectedComponent();
        if (component == null) {
            errorInfoArray = ErrorInfo.EMPTY_ARRAY;
            if (ErrorInfo.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/componentTree/QuickFixManagerImpl.getErrorInfos must not return null");
            return errorInfoArray;
        }
        errorInfoArray = ErrorAnalyzer.getAllErrorsForComponent(component);
        if (errorInfoArray != null) return errorInfoArray;
        throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/componentTree/QuickFixManagerImpl.getErrorInfos must not return null");
    }

    @Override
    public Rectangle getErrorBounds() {
        TreePath selectionPath = ((ComponentTree)((Object)this.myComponent)).getSelectionPath();
        LOG.assertTrue(selectionPath != null);
        return ((ComponentTree)((Object)this.myComponent)).getPathBounds(selectionPath);
    }

    private final class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            QuickFixManagerImpl.this.hideIntentionHint();
            QuickFixManagerImpl.this.updateIntentionHintVisibility();
            ErrorInfo[] errorInfos = QuickFixManagerImpl.this.getErrorInfos();
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(((ComponentTree)((Object)QuickFixManagerImpl.this.myComponent)).getProject());
            if (errorInfos.length > 0 && errorInfos[0].myDescription != null) {
                statusBar.setInfo(errorInfos[0].myDescription);
            } else {
                statusBar.setInfo("");
            }
        }
    }
}

