/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.HierarchyChangeListener;
import com.intellij.uiDesigner.SelectionWatcher;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentPtrDescriptor;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.componentTree.ComponentTreeStructure;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyInspector;
import com.intellij.uiDesigner.propertyInspector.UIDesignerToolWindowManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public final class ComponentTreeBuilder
extends AbstractTreeBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.componentTree.ComponentTreeBuilder");
    private final GuiEditor myEditor;
    private final MySelectionWatcher mySelectionWatcher;
    private int myInsideChange;
    private final MyHierarchyChangeListener myHierarchyChangeListener;
    private MyTreeSelectionListener myTreeSelectionListener;

    public ComponentTreeBuilder(ComponentTree tree, @NotNull GuiEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentTreeBuilder.<init> must not be null");
        }
        super((JTree)((Object)tree), (DefaultTreeModel)tree.getModel(), (AbstractTreeStructure)new ComponentTreeStructure(editor), (Comparator)MyComparator.ourComparator);
        this.myEditor = editor;
        this.mySelectionWatcher = new MySelectionWatcher(editor);
        this.initRootNode();
        this.syncSelection();
        this.myTreeSelectionListener = new MyTreeSelectionListener();
        this.myHierarchyChangeListener = new MyHierarchyChangeListener();
        this.getTree().getSelectionModel().addTreeSelectionListener(this.myTreeSelectionListener);
        editor.addHierarchyChangeListener(this.myHierarchyChangeListener);
    }

    public void dispose() {
        this.myEditor.removeHierarchyChangeListener(this.myHierarchyChangeListener);
        if (this.myTreeSelectionListener != null) {
            this.getTree().getSelectionModel().removeTreeSelectionListener(this.myTreeSelectionListener);
            this.myTreeSelectionListener = null;
        }
        this.mySelectionWatcher.dispose();
        super.dispose();
    }

    private ComponentTreeStructure getComponentTreeStructure() {
        return (ComponentTreeStructure)this.getTreeStructure();
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        return false;
    }

    protected boolean isAutoExpandNode(NodeDescriptor descriptor) {
        return this.getComponentTreeStructure().isAutoExpandNode(descriptor);
    }

    public void beginUpdateSelection() {
        ++this.myInsideChange;
    }

    public void endUpdateSelection() {
        --this.myInsideChange;
        this.updateSelection();
    }

    private void syncSelection() {
        RadRootContainer rootContainer = this.myEditor.getRootContainer();
        final ArrayList<RadRootContainer> selection = new ArrayList<RadRootContainer>();
        FormEditingUtil.iterate(rootContainer, new FormEditingUtil.ComponentVisitor<RadComponent>(){

            @Override
            public boolean visit(RadComponent component) {
                if (component.isSelected()) {
                    selection.add(component);
                }
                return true;
            }
        });
        if (selection.size() == 0) {
            selection.add(rootContainer);
        }
        Object[] componentPtrs = new ComponentPtr[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            componentPtrs[i] = new ComponentPtr(this.myEditor, (RadComponent)selection.get(i));
        }
        this.select(componentPtrs, null);
        this.myEditor.fireSelectedComponentChanged();
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StatusBarProgress statusBarProgress = new StatusBarProgress();
        if (statusBarProgress == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/componentTree/ComponentTreeBuilder.createProgressIndicator must not return null");
        }
        return statusBarProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelection() {
        PropertyInspector propertyInspector = UIDesignerToolWindowManager.getInstance(this.myEditor.getProject()).getPropertyInspector();
        if (propertyInspector.isEditing()) {
            propertyInspector.stopEditing();
        }
        if (this.myInsideChange > 0) {
            return;
        }
        ++this.myInsideChange;
        try {
            this.updateFromRoot();
            this.syncSelection();
        }
        finally {
            --this.myInsideChange;
        }
    }

    private final class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (ComponentTreeBuilder.this.myInsideChange > 0) {
                return;
            }
            Set selectedElements = ComponentTreeBuilder.this.getSelectedElements(ComponentPtr.class);
            ComponentTreeBuilder.this.myInsideChange++;
            try {
                FormEditingUtil.clearSelection(ComponentTreeBuilder.this.myEditor.getRootContainer());
                boolean hasComponentInTab = false;
                int count = 0;
                for (ComponentPtr ptr : selectedElements) {
                    if (!ptr.isValid()) continue;
                    RadComponent component = ptr.getComponent();
                    LOG.assertTrue(component != null);
                    if (!hasComponentInTab) {
                        hasComponentInTab = FormEditingUtil.selectComponent(ComponentTreeBuilder.this.myEditor, component);
                    } else {
                        component.setSelected(true);
                    }
                    if (++count != selectedElements.size()) continue;
                    ComponentTreeBuilder.this.myEditor.scrollComponentInView(component);
                }
                ComponentTreeBuilder.this.myEditor.fireSelectedComponentChanged();
            }
            finally {
                ComponentTreeBuilder.this.myInsideChange--;
            }
        }
    }

    private final class MySelectionWatcher
    extends SelectionWatcher {
        public MySelectionWatcher(GuiEditor editor) {
            super(editor);
        }

        @Override
        protected void selectionChanged(RadComponent component, boolean ignored) {
            ComponentTreeBuilder.this.updateSelection();
        }
    }

    private final class MyHierarchyChangeListener
    implements HierarchyChangeListener {
        private MyHierarchyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hierarchyChanged() {
            if (ComponentTreeBuilder.this.myInsideChange > 0) {
                return;
            }
            ComponentTreeBuilder.this.myInsideChange++;
            try {
                ComponentTreeBuilder.this.updateFromRoot();
                ComponentTreeBuilder.this.syncSelection();
            }
            finally {
                ComponentTreeBuilder.this.myInsideChange--;
            }
        }
    }

    private static final class MyComparator
    implements Comparator<NodeDescriptor> {
        public static final MyComparator ourComparator = new MyComparator();

        private MyComparator() {
        }

        private static int indexOf(RadContainer container, RadComponent component) {
            if (container != null) {
                for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                    if (!component.equals(container.getComponent(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int compare(NodeDescriptor descriptor1, NodeDescriptor descriptor2) {
            if (descriptor1 instanceof ComponentPtrDescriptor && descriptor2 instanceof ComponentPtrDescriptor) {
                RadContainer container2;
                RadComponent component1 = ((ComponentPtrDescriptor)descriptor1).getComponent();
                RadComponent component2 = ((ComponentPtrDescriptor)descriptor2).getComponent();
                if (component1 == null || component2 == null) {
                    return 0;
                }
                RadContainer container1 = component1.getParent();
                if (Comparing.equal((Object)container1, (Object)(container2 = component2.getParent()))) {
                    return MyComparator.indexOf(container1, component1) - MyComparator.indexOf(container2, component2);
                }
                return 0;
            }
            return 0;
        }
    }
}

