/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GeneratedCodeFoldingPass
extends TextEditorHighlightingPass {
    private final PsiFile myPsiFile;
    private final Editor myEditor;
    private final List<TextRange> myFoldingData;

    protected GeneratedCodeFoldingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/binding/GeneratedCodeFoldingPass.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/binding/GeneratedCodeFoldingPass.<init> must not be null");
        }
        super(psiFile.getProject(), editor.getDocument(), false);
        this.myFoldingData = new ArrayList<TextRange>();
        this.myPsiFile = psiFile;
        this.myEditor = editor;
    }

    public void doCollectInformation(ProgressIndicator progress) {
        this.myPsiFile.accept((PsiElementVisitor)new MyFoldingVisitor(progress));
    }

    public void doApplyInformationToEditor() {
        this.myEditor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FoldingModel foldingModel = GeneratedCodeFoldingPass.this.myEditor.getFoldingModel();
                List list = GeneratedCodeFoldingPass.this.myFoldingData;
                synchronized (list) {
                    for (TextRange foldingData : GeneratedCodeFoldingPass.this.myFoldingData) {
                        FoldRegion[] regions;
                        int startOffset = foldingData.getStartOffset();
                        int endOffset = foldingData.getEndOffset();
                        boolean generatedCodeUnfolded = false;
                        for (FoldRegion region : regions = foldingModel.getAllFoldRegions()) {
                            if (region.getPlaceholderText().equals(UIDesignerBundle.message("uidesigner.generated.code.folding.placeholder.text", new Object[0])) && region.isExpanded()) {
                                generatedCodeUnfolded = true;
                            }
                            if (region.getStartOffset() < startOffset || region.getEndOffset() > endOffset) continue;
                            foldingModel.removeFoldRegion(region);
                        }
                        FoldRegion region = foldingModel.addFoldRegion(startOffset, endOffset, UIDesignerBundle.message("uidesigner.generated.code.folding.placeholder.text", new Object[0]));
                        if (region == null || generatedCodeUnfolded) continue;
                        region.setExpanded(false);
                    }
                }
            }
        });
    }

    private static boolean isGeneratedUIInitializer(PsiClassInitializer initializer) {
        PsiCodeBlock body = initializer.getBody();
        if (body.getStatements().length != 1) {
            return false;
        }
        PsiStatement statement = body.getStatements()[0];
        if (!(statement instanceof PsiExpressionStatement) || !(((PsiExpressionStatement)statement).getExpression() instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)((PsiExpressionStatement)statement).getExpression();
        return "$$$setupUI$$$".equals(call.getMethodExpression().getReferenceName());
    }

    private class MyFoldingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final ProgressIndicator myProgress;
        private PsiElement myLastElement;

        private MyFoldingVisitor(ProgressIndicator progress) {
            this.myProgress = progress;
        }

        public void visitMethod(PsiMethod method) {
            this.myProgress.checkCanceled();
            if ("$$$setupUI$$$".equals(method.getName()) || "$$$getRootComponent$$$".equals(method.getName()) || "$$$loadButtonText$$$".equals(method.getName()) || "$$$loadLabelText$$$".equals(method.getName())) {
                this.addFoldingData((PsiElement)method);
            }
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            this.myProgress.checkCanceled();
            if (GeneratedCodeFoldingPass.isGeneratedUIInitializer(initializer)) {
                this.addFoldingData((PsiElement)initializer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFoldingData(PsiElement element) {
            PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
            List list = GeneratedCodeFoldingPass.this.myFoldingData;
            synchronized (list) {
                if (this.myLastElement == null || prevSibling != this.myLastElement) {
                    GeneratedCodeFoldingPass.this.myFoldingData.add(element.getTextRange());
                } else {
                    TextRange lastRange = (TextRange)GeneratedCodeFoldingPass.this.myFoldingData.get(GeneratedCodeFoldingPass.this.myFoldingData.size() - 1);
                    GeneratedCodeFoldingPass.this.myFoldingData.set(GeneratedCodeFoldingPass.this.myFoldingData.size() - 1, new TextRange(lastRange.getStartOffset(), element.getTextRange().getEndOffset()));
                }
            }
            this.myLastElement = element;
        }
    }
}

