/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.actions.GroupButtonsAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UngroupButtonsAction
extends AbstractGuiEditorAction {
    public UngroupButtonsAction() {
        super(true);
    }

    @Override
    protected void actionPerformed(GuiEditor editor, List<RadComponent> selection, AnActionEvent e) {
        if (selection.size() == 1) {
            RadComponent component = selection.get(0);
            IButtonGroup group = FormEditingUtil.findGroupForComponent(editor.getRootContainer(), component);
            editor.getRootContainer().deleteGroup((RadButtonGroup)group);
        } else {
            for (RadComponent component : selection) {
                editor.getRootContainer().setGroupForComponent(component, null);
            }
        }
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/actions/UngroupButtonsAction.update must not be null");
        }
        boolean visible = GroupButtonsAction.allButtons(selection);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && UngroupButtonsAction.canUngroup(editor, selection));
    }

    private static boolean canUngroup(GuiEditor editor, ArrayList<RadComponent> selectedComponents) {
        if (selectedComponents.size() < 2) {
            return selectedComponents.size() == 1;
        }
        return UngroupButtonsAction.isSameGroup(editor, selectedComponents);
    }

    public static boolean isSameGroup(GuiEditor editor, ArrayList<RadComponent> selectedComponents) {
        RadRootContainer rootContainer = editor.getRootContainer();
        IButtonGroup group = FormEditingUtil.findGroupForComponent(rootContainer, selectedComponents.get(0));
        if (group == null) {
            return false;
        }
        for (int i = 1; i < selectedComponents.size(); ++i) {
            if (FormEditingUtil.findGroupForComponent(rootContainer, selectedComponents.get(i)) == group) continue;
            return false;
        }
        return true;
    }
}

