/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.cli.AbstractConsoleDownloadMonitor;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.logging.Logger;

public class ConsoleDownloadMonitor
extends AbstractConsoleDownloadMonitor {
    private Map downloads = new LinkedHashMap();
    private int maxLength;

    public ConsoleDownloadMonitor(Logger logger) {
        super(logger);
    }

    public ConsoleDownloadMonitor() {
    }

    public void transferInitiated(TransferEvent transferEvent) {
        String message = transferEvent.getRequestType() == 6 ? "Uploading" : "Downloading";
        String url = transferEvent.getWagon().getRepository().getUrl();
        this.out.println(message + ": " + url + "/" + transferEvent.getResource().getName());
    }

    public void transferStarted(TransferEvent transferEvent) {
    }

    public synchronized void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        Resource resource = transferEvent.getResource();
        if (!this.downloads.containsKey(resource)) {
            this.downloads.put(resource, new Long(length));
        } else {
            Long complete = (Long)this.downloads.get(resource);
            complete = new Long(complete + (long)length);
            this.downloads.put(resource, complete);
        }
        StringBuffer buf = new StringBuffer();
        Iterator i = this.downloads.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Long complete = (Long)entry.getValue();
            String status = this.getDownloadStatusForResource(complete, ((Resource)entry.getKey()).getContentLength());
            buf.append(status);
            if (!i.hasNext()) continue;
            buf.append(" ");
        }
        if (buf.length() > this.maxLength) {
            this.maxLength = buf.length();
        }
        this.out.print(buf.toString() + "\r");
    }

    String getDownloadStatusForResource(long progress, long total) {
        if (total >= 1024L) {
            return progress / 1024L + "/" + (total == -1L ? "?" : total / 1024L + "K");
        }
        return progress + "/" + (total == -1L ? "?" : total + "b");
    }

    public synchronized void transferCompleted(TransferEvent transferEvent) {
        StringBuffer line = new StringBuffer(this.createCompletionLine(transferEvent));
        while (line.length() < this.maxLength) {
            line.append(" ");
        }
        this.maxLength = 0;
        this.out.println(line);
        this.downloads.remove(transferEvent.getResource());
    }
}

