/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.junit3.JUnit3IdeaTestRunner;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class JUnitStarter {
    public static final int VERSION = 5;
    public static final String IDE_VERSION = "-ideVersion";
    public static final String JUNIT4_PARAMETER = "-junit4";
    private static final String SOCKET = "-socket";

    public static void main(String[] args) throws IOException {
        SegmentedOutputStream out = new SegmentedOutputStream(System.out);
        SegmentedOutputStream err = new SegmentedOutputStream(System.err);
        Vector<String> argList = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            argList.addElement(arg);
        }
        ArrayList listeners = new ArrayList();
        boolean isJUnit4 = JUnitStarter.processParameters(argList, listeners);
        if (!JUnitStarter.canWorkWithJUnitVersion((OutputStream)err, isJUnit4)) {
            err.flush();
            System.exit(-3);
        }
        if (!JUnitStarter.checkVersion(args, err)) {
            err.flush();
            System.exit(-3);
        }
        Object[] array = new String[argList.size()];
        argList.copyInto(array);
        int exitCode = JUnitStarter.prepareStreamsAndStart((String[])array, isJUnit4, listeners, out, err);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processParameters(Vector args, List listeners) {
        String arg;
        int i;
        boolean isJunit4 = false;
        String tempFilePath = null;
        Vector<String> result = new Vector<String>(args.size());
        for (i = 0; i < args.size(); ++i) {
            arg = (String)args.get(i);
            if (arg.startsWith(IDE_VERSION)) continue;
            if (arg.equals(JUNIT4_PARAMETER)) {
                isJunit4 = true;
                continue;
            }
            if (arg.startsWith("@@")) {
                if (!new File(arg.substring(2)).exists()) continue;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(arg.substring(2)));
                    while ((line = reader.readLine()) != null) {
                        listeners.add(line);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (arg.startsWith("@")) {
                tempFilePath = arg.substring(1);
            } else if (arg.startsWith(SOCKET)) {
                int port = Integer.parseInt(arg.substring(SOCKET.length()));
                try {
                    Socket socket = new Socket(InetAddress.getByName(null), port);
                    DataInputStream os = new DataInputStream(socket.getInputStream());
                    try {
                        os.readBoolean();
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                isJunit4 = JUnitStarter.isJUnit4(isJunit4, tempFilePath);
                continue;
            }
            result.addElement(arg);
        }
        args.removeAllElements();
        for (i = 0; i < result.size(); ++i) {
            arg = (String)result.get(i);
            args.addElement(arg);
        }
        return isJunit4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isJUnit4(boolean junit4, String tempFilePath) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(tempFilePath));
            try {
                junit4 |= JUNIT4_PARAMETER.equals(reader.readLine());
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return junit4;
    }

    public static boolean checkVersion(String[] args, SegmentedOutputStream notifications) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith(IDE_VERSION)) continue;
            int ideVersion = Integer.parseInt(arg.substring(IDE_VERSION.length(), arg.length()));
            if (ideVersion != 5) {
                PrintStream stream = new PrintStream((OutputStream)notifications);
                stream.println("Wrong agent version: 5. IDE expects version: " + ideVersion);
                stream.flush();
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWorkWithJUnitVersion(OutputStream notifications, boolean isJUnit4) {
        PrintStream stream = new PrintStream(notifications);
        try {
            JUnitStarter.junitVersionChecks(isJUnit4);
        }
        catch (Throwable e) {
            stream.println("!!! JUnit version 3.8 or later expected:");
            stream.println();
            e.printStackTrace(stream);
            stream.flush();
            boolean bl = false;
            return bl;
        }
        finally {
            stream.flush();
        }
        return true;
    }

    private static void junitVersionChecks(boolean isJUnit4) throws ClassNotFoundException {
        Class.forName("junit.framework.ComparisonFailure");
        JUnitStarter.getAgentClass(isJUnit4);
        new TestRunner().setPrinter((ResultPrinter)new JUnit3IdeaTestRunner.MockResultPrinter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int prepareStreamsAndStart(String[] args, boolean isJUnit4, ArrayList listeners, SegmentedOutputStream out, SegmentedOutputStream err) {
        int result;
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        try {
            System.setOut(new PrintStream((OutputStream)out));
            System.setErr(new PrintStream((OutputStream)err));
            IdeaTestRunner testRunner = (IdeaTestRunner)JUnitStarter.getAgentClass(isJUnit4).newInstance();
            testRunner.setStreams(out, err);
            result = testRunner.startRunnerWithArgs(args, listeners);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            result = -2;
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        return result;
    }

    private static Class getAgentClass(boolean isJUnit4) throws ClassNotFoundException {
        return isJUnit4 ? Class.forName("com.intellij.junit4.JUnit4IdeaTestRunner") : Class.forName("com.intellij.junit3.JUnit3IdeaTestRunner");
    }
}

