/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.JUnit3OutputObjectRegistry;
import com.intellij.junit3.TestResultsSender;
import com.intellij.junit3.TestRunnerUtil;
import com.intellij.junit3.TreeSender;
import com.intellij.rt.execution.junit.DeafStream;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.util.ArrayList;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class JUnit3IdeaTestRunner
extends TestRunner
implements IdeaTestRunner {
    private TestListener myTestsListener;
    private JUnit3OutputObjectRegistry myRegistry;
    private ArrayList myListeners;

    public JUnit3IdeaTestRunner() {
        super(DeafStream.DEAF_PRINT_STREAM);
    }

    public int startRunnerWithArgs(String[] args, ArrayList listeners) {
        this.myListeners = listeners;
        try {
            Test suite = TestRunnerUtil.getTestSuite(this, args);
            TestResult result = this.doRun(suite);
            if (!result.wasSuccessful()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -2;
        }
    }

    public void clearStatus() {
        super.clearStatus();
    }

    public void runFailed(String message) {
        super.runFailed(message);
    }

    public void setStreams(SegmentedOutputStream segmentedOut, SegmentedOutputStream segmentedErr) {
        this.setPrinter(new TimeSender());
        this.myRegistry = new JUnit3OutputObjectRegistry((PacketProcessor)segmentedOut, (PacketProcessor)segmentedErr);
        this.myTestsListener = new TestResultsSender(this.myRegistry, (PacketProcessor)segmentedErr);
    }

    protected TestResult createTestResult() {
        TestResult testResult = super.createTestResult();
        testResult.addListener(this.myTestsListener);
        try {
            for (int i = 0; i < this.myListeners.size(); ++i) {
                final IDEAJUnitListener junitListener = (IDEAJUnitListener)Class.forName((String)this.myListeners.get(i)).newInstance();
                testResult.addListener(new TestListener(){

                    public void addError(Test test, Throwable t) {
                    }

                    public void addFailure(Test test, AssertionFailedError t) {
                    }

                    public void endTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testFinished(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }

                    public void startTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testStarted(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testResult;
    }

    public TestResult doRun(Test suite, boolean wait) {
        try {
            TreeSender.sendSuite(this.myRegistry, suite);
        }
        catch (Exception e) {
            System.err.println("Internal Error occured.");
            e.printStackTrace(System.err);
        }
        return super.doRun(suite, wait);
    }

    private class TimeSender
    extends ResultPrinter {
        public TimeSender() {
            super(DeafStream.DEAF_PRINT_STREAM);
        }

        protected void printHeader(long runTime) {
            JUnit3IdeaTestRunner.this.myRegistry.createPacket().addString("D").addLong(runTime).send();
        }
    }

    public static class MockResultPrinter
    extends ResultPrinter {
        public MockResultPrinter() {
            super(DeafStream.DEAF_PRINT_STREAM);
        }
    }
}

