/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

class GitFixRootsDialog
extends DialogWrapper {
    private JList myGitRoots;
    private JPanel myPanel;

    protected GitFixRootsDialog(Project project, HashSet<String> current, HashSet<String> added, HashSet<String> removed) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("fix.roots.title"));
        this.setOKButtonText(GitBundle.getString("fix.roots.button"));
        TreeSet<Item> items = new TreeSet<Item>();
        for (String f : added) {
            items.add(new Item(f, FileStatus.ADDED));
        }
        for (String f : current) {
            items.add(new Item(f, removed.contains(f) ? FileStatus.DELETED : FileStatus.NOT_CHANGED));
        }
        DefaultListModel<Item> listModel = new DefaultListModel<Item>();
        for (Item i : items) {
            listModel.addElement(i);
        }
        this.myGitRoots.setModel(listModel);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JList jList;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("fix.roots.message"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myGitRoots = jList = new JList();
        jList.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("fix.roots.list.tooltip"));
        jScrollPane.setViewportView(jList);
        jLabel.setLabelFor(jScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class Item
    implements Comparable<Item> {
        @NotNull
        final FileStatus status;
        @NotNull
        final String fileName;

        public Item(@NotNull String fileName, FileStatus status) {
            if (fileName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/vfs/GitFixRootsDialog$Item.<init> must not be null");
            }
            if (status == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/vfs/GitFixRootsDialog$Item.<init> must not be null");
            }
            this.fileName = fileName;
            this.status = status;
        }

        @Override
        public int compareTo(Item o) {
            return this.fileName.compareTo(o.fileName);
        }

        public String toString() {
            if (this.status == FileStatus.ADDED) {
                return "<html><b>" + this.fileName + "</b></html>";
            }
            if (this.status == FileStatus.DELETED) {
                return "<html><strike>" + this.fileName + "</strike></html>";
            }
            return this.fileName;
        }
    }
}

