/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.text.StringTokenizer;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranch;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitSimpleHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GitHistoryUtils {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.GitHistoryUtils");

    private GitHistoryUtils() {
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(Project project, FilePath filePath) throws VcsException {
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters("-n1", "--pretty=format:%H%n%ct%n");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        String[] lines = result.split("\n");
        String hash = lines[0];
        Date commitDate = GitUtil.parseTimestamp(lines[1]);
        return new GitRevisionNumber(hash, commitDate);
    }

    @Nullable
    public static ItemLatestState getLastRevision(Project project, FilePath filePath) throws VcsException {
        GitBranch t;
        VirtualFile root = GitUtil.getGitRoot(filePath);
        GitBranch c = GitBranch.current(project, root);
        GitBranch gitBranch = t = c == null ? null : c.tracked(project, root);
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath), true, false);
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters("-n1", "--pretty=format:%H%n%ct", "--name-status", t.getFullName());
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        String[] lines = result.split("\n");
        String hash = lines[0];
        boolean exists = lines.length < 3 || lines[2].charAt(0) != 'D';
        Date commitDate = GitUtil.parseTimestamp(lines[1]);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(hash, commitDate), exists, false);
    }

    public static void history(final Project project, FilePath path, final Consumer<GitFileRevision> consumer, final Consumer<VcsException> exceptionConsumer) throws VcsException {
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setNoSSH(true);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "--follow", "--name-only", "--pretty=tformat:%x03%x01%x03%H%x03%ct%x03%an%x20%x3C%ae%x3E%x03%cn%x20%x3C%ce%x3E%x03%x02%x03%s%x03%b", "--encoding=UTF-8");
        h.endOptions();
        h.addRelativePaths(path);
        final String prefix = root.getPath() + "/";
        final MyTokenAccumulator accumulator = new MyTokenAccumulator(6);
        Consumer<List<String>> resultAdapter = new Consumer<List<String>>(){

            public void consume(List<String> result) {
                GitRevisionNumber revision = new GitRevisionNumber(result.get(0), GitUtil.parseTimestamp(result.get(1)));
                String author = GitUtil.adjustAuthorName(result.get(2), result.get(3));
                String message = result.get(4).trim();
                String path = "";
                try {
                    path = GitUtil.unescapePath(result.get(5));
                }
                catch (VcsException e) {
                    exceptionConsumer.consume((Object)e);
                }
                FilePath revisionPath = VcsUtil.getFilePathForDeletedFile((String)(prefix + path), (boolean)false);
                consumer.consume((Object)new GitFileRevision(project, revisionPath, revision, author, message, null));
            }
        };
        Semaphore semaphore = new Semaphore();
        h.addLineListener(new GitLineHandlerAdapter((Consumer)resultAdapter, exceptionConsumer, semaphore){
            final /* synthetic */ Consumer val$resultAdapter;
            final /* synthetic */ Consumer val$exceptionConsumer;
            final /* synthetic */ Semaphore val$semaphore;
            {
                this.val$resultAdapter = consumer;
                this.val$exceptionConsumer = consumer2;
                this.val$semaphore = semaphore;
            }

            @Override
            public void onLineAvailable(String line, Key outputType) {
                List<String> result = accumulator.acceptLine(line);
                if (result != null) {
                    this.val$resultAdapter.consume(result);
                }
            }

            @Override
            public void startFailed(Throwable exception) {
                this.val$exceptionConsumer.consume((Object)new VcsException(exception));
            }

            @Override
            public void processTerminated(int exitCode) {
                super.processTerminated(exitCode);
                List<String> result = accumulator.processLast();
                if (result != null) {
                    this.val$resultAdapter.consume(result);
                }
                this.val$semaphore.up();
            }
        });
        semaphore.down();
        h.start();
        semaphore.waitFor();
    }

    public static List<VcsFileRevision> history(Project project, FilePath path) throws VcsException {
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        h.setNoSSH(true);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "--follow", "--name-only", "--pretty=format:%H%x03%ct%x03%an%x20%x3C%ae%x3E%x03%cn%x20%x3C%ce%x3E%x03%s%n%n%b%x03", "--encoding=UTF-8");
        h.endOptions();
        h.addRelativePaths(path);
        String output = h.run();
        ArrayList<VcsFileRevision> rc = new ArrayList<VcsFileRevision>();
        StringTokenizer tk = new StringTokenizer(output, "\u0003\n", false);
        String prefix = root.getPath() + "/";
        while (tk.hasMoreTokens()) {
            GitRevisionNumber revision = new GitRevisionNumber(tk.nextToken("\u0003\n"), GitUtil.parseTimestamp(tk.nextToken("\u0003")));
            String author = GitUtil.adjustAuthorName(tk.nextToken("\u0003"), tk.nextToken("\u0003"));
            String message = tk.nextToken("\u0003").trim();
            FilePath revisionPath = VcsUtil.getFilePathForDeletedFile((String)(prefix + GitUtil.unescapePath(tk.nextToken("\u0003\n"))), (boolean)false);
            rc.add(new GitFileRevision(project, revisionPath, revision, author, message, null));
        }
        return rc;
    }

    public static FilePath getLastCommitName(Project project, FilePath path) {
        ChangeListManager changeManager = ChangeListManager.getInstance((Project)project);
        Change change = changeManager.getChange(path);
        if (change != null && change.getType() == Change.Type.MOVED) {
            GitContentRevision r = (GitContentRevision)change.getBeforeRevision();
            assert (r != null) : "Move change always have beforeRevision";
            path = r.getFile();
        }
        return path;
    }

    private static class MyTokenAccumulator {
        private static final String ourCommentStartMark = "\u0003\u0002\u0003";
        private static final String ourCommentEndMark = "\u0003\u0002\u0001";
        private static final String ourLineEndMark = "\u0003\u0001\u0003";
        private final StringBuilder myBuffer;
        private final int myMax;
        private boolean myNotStarted;

        private MyTokenAccumulator(int max) {
            this.myMax = max;
            this.myBuffer = new StringBuilder();
            this.myNotStarted = true;
        }

        @Nullable
        public List<String> acceptLine(String s) {
            boolean lineEnd = s.startsWith(ourLineEndMark);
            if (lineEnd && !this.myNotStarted) {
                String line = this.myBuffer.toString();
                this.myBuffer.setLength(0);
                this.myBuffer.append(s.substring(3));
                return MyTokenAccumulator.processResult(line);
            }
            this.myBuffer.append(lineEnd ? s.substring(3) : s);
            this.myBuffer.append('\u0002');
            this.myNotStarted = false;
            return null;
        }

        public List<String> processLast() {
            return MyTokenAccumulator.processResult(this.myBuffer.toString());
        }

        private static List<String> processResult(String line) {
            int commentStartIdx = line.indexOf(ourCommentStartMark);
            String start = line.substring(0, commentStartIdx);
            java.util.StringTokenizer tk = new java.util.StringTokenizer(start, "\u0003", false);
            ArrayList<String> result = new ArrayList<String>();
            while (tk.hasMoreElements()) {
                String token = tk.nextToken();
                result.add(token);
            }
            String part = line.substring(commentStartIdx + 3).replace('\u0002', '\n').replace('\u0003', '\n').trim();
            int commentEndIdx = part.lastIndexOf(10);
            result.add(part.substring(0, commentEndIdx));
            result.add(part.substring(commentEndIdx).trim());
            return result;
        }
    }
}

