/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitVcs;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitVcsPanel {
    private JButton myTestButton;
    private JComponent myPanel;
    private TextFieldWithBrowseButton myGitField;
    private JComboBox mySSHExecutableComboBox;
    private JComboBox myConvertTextFilesComboBox;
    private JCheckBox myAskBeforeConversionsCheckBox;
    private final Project myProject;
    private final GitVcsSettings mySettings;
    private static final String IDEA_SSH = ApplicationNamesInfo.getInstance().getProductName() + " " + GitBundle.getString("git.vcs.config.ssh.mode.idea");
    private static final String NATIVE_SSH = GitBundle.getString("git.vcs.config.ssh.mode.native");
    private static final String CRLF_CONVERT_TO_PROJECT = GitBundle.getString("git.vcs.config.convert.project");
    private static final String CRLF_DO_NOT_CONVERT = GitBundle.getString("git.vcs.config.convert.do.not.convert");

    public GitVcsPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/config/GitVcsPanel.<init> must not be null");
        }
        this.$$$setupUI$$$();
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myProject = project;
        this.mySSHExecutableComboBox.addItem(IDEA_SSH);
        this.mySSHExecutableComboBox.addItem(NATIVE_SSH);
        this.mySSHExecutableComboBox.setSelectedItem(GitVcsSettings.isDefaultIdeaSsh() ? IDEA_SSH : NATIVE_SSH);
        this.mySSHExecutableComboBox.setToolTipText(GitBundle.message("git.vcs.config.ssh.mode.tooltip", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.myAskBeforeConversionsCheckBox.setSelected(this.mySettings.askBeforeLineSeparatorConversion());
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitVcsPanel.this.testConnection();
            }
        });
        this.myConvertTextFilesComboBox.addItem(CRLF_DO_NOT_CONVERT);
        this.myConvertTextFilesComboBox.addItem(CRLF_CONVERT_TO_PROJECT);
        this.myConvertTextFilesComboBox.setSelectedItem(CRLF_CONVERT_TO_PROJECT);
        this.myGitField.addBrowseFolderListener(GitBundle.getString("find.git.title"), GitBundle.getString("find.git.description"), project, new FileChooserDescriptor(true, false, false, false, false, false));
    }

    private void testConnection() {
        String s;
        this.mySettings.setGitExecutable(this.myGitField.getText());
        try {
            s = GitVcs.version(this.myProject);
        }
        catch (VcsException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)GitBundle.getString("find.git.error.title"));
            return;
        }
        if (GitVersion.parse(s).isSupported()) {
            Messages.showInfoMessage((Project)this.myProject, (String)s, (String)GitBundle.getString("find.git.success.title"));
        } else {
            Messages.showWarningDialog((Project)this.myProject, (String)GitBundle.message("find.git.unsupported.message", s, GitVersion.MIN), (String)GitBundle.getString("find.git.success.title"));
        }
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void load(@NotNull GitVcsSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/config/GitVcsPanel.load must not be null");
        }
        this.myGitField.setText(settings.getGitExecutable());
        this.mySSHExecutableComboBox.setSelectedItem(settings.isIdeaSsh() ? IDEA_SSH : NATIVE_SSH);
        this.myAskBeforeConversionsCheckBox.setSelected(settings.askBeforeLineSeparatorConversion());
        this.myConvertTextFilesComboBox.setSelectedItem(GitVcsPanel.crlfPolicyItem(settings));
    }

    private static String crlfPolicyItem(GitVcsSettings settings) {
        String crlf;
        switch (settings.getLineSeparatorsConversion()) {
            case NONE: {
                crlf = CRLF_DO_NOT_CONVERT;
                break;
            }
            case PROJECT_LINE_SEPARATORS: {
                crlf = CRLF_CONVERT_TO_PROJECT;
                break;
            }
            default: {
                assert (false) : "Unknown crlf policy: " + (Object)((Object)settings.getLineSeparatorsConversion());
                crlf = null;
            }
        }
        return crlf;
    }

    public boolean isModified(@NotNull GitVcsSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/config/GitVcsPanel.isModified must not be null");
        }
        return !settings.getGitExecutable().equals(this.myGitField.getText()) || settings.isIdeaSsh() != IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) || !GitVcsPanel.crlfPolicyItem(settings).equals(this.myConvertTextFilesComboBox.getSelectedItem()) || settings.askBeforeLineSeparatorConversion() != this.myAskBeforeConversionsCheckBox.isSelected();
    }

    public void save(@NotNull GitVcsSettings settings) {
        GitVcsSettings.ConversionPolicy conversionPolicy;
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/config/GitVcsPanel.save must not be null");
        }
        settings.setGitExecutable(this.myGitField.getText());
        settings.setIdeaSsh(IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()));
        Object policyItem = this.myConvertTextFilesComboBox.getSelectedItem();
        if (CRLF_DO_NOT_CONVERT.equals(policyItem)) {
            conversionPolicy = GitVcsSettings.ConversionPolicy.NONE;
        } else if (CRLF_CONVERT_TO_PROJECT.equals(policyItem)) {
            conversionPolicy = GitVcsSettings.ConversionPolicy.PROJECT_LINE_SEPARATORS;
        } else {
            throw new IllegalStateException("Unknown selected CRLF policy: " + policyItem);
        }
        settings.setLineSeparatorsConversion(conversionPolicy);
        settings.setAskBeforeLineSeparatorConversion(this.myAskBeforeConversionsCheckBox.isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel = new JPanel();
        this.myPanel = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.convert.ask"));
        JLabel jLabel = new JLabel();
        jLabel.setVerifyInputWhenFocusTarget(false);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.path.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setHorizontalAlignment(0);
        jButton.setLabel(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test.label"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test"));
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 2, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.ssh.mode"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySSHExecutableComboBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.convert.crlf"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConvertTextFilesComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.convert.tooltip"));
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAskBeforeConversionsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.convert.ask"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.convert.ask.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

