/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckoutProvider
implements CheckoutProvider {
    private static final GitVersion VERBOSE_CLONE_SUPPORTED = new GitVersion(1, 6, 0, 5);

    public void doCheckout(final @NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/checkout/GitCheckoutProvider.doCheckout must not be null");
        }
        BasicAction.saveAll();
        GitCloneDialog dialog = new GitCloneDialog(project);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        final VirtualFile destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(dialog.getParentDirectory()));
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        GitLineHandler handler = GitCheckoutProvider.clone(project, sourceRepositoryURL, new File(dialog.getParentDirectory()), dialog.getDirectoryName(), dialog.getOriginName());
        int code = GitHandlerUtil.doSynchronously(handler, GitBundle.message("cloning.repository", sourceRepositoryURL), "git clone");
        destinationParent.refresh(true, true, new Runnable(){

            @Override
            public void run() {
                if (!project.isDefault()) {
                    VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                    mgr.fileDirty(destinationParent);
                }
            }
        });
        if (code == 0 && listener != null) {
            listener.directoryCheckedOut(new File(dialog.getParentDirectory(), dialog.getDirectoryName()));
        }
        if (listener != null) {
            listener.checkoutCompleted();
        }
    }

    public String getVcsName() {
        return "_Git";
    }

    public static GitLineHandler clone(Project project, String url, File directory, String name, String originName) {
        GitLineHandler handler = new GitLineHandler(project, directory, GitCommand.CLONE);
        if (VERBOSE_CLONE_SUPPORTED.isLessOrEqual(GitVcs.getInstance(project).version())) {
            handler.addParameters("-v");
        }
        if (originName != null && originName.length() > 0) {
            handler.addParameters("-o", originName);
        }
        handler.addParameters(url, name);
        return handler;
    }
}

