/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.ChangeCollector;
import git4idea.changes.GitChangeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.changes.GitChangeProvider");
    private final Project myProject;

    public GitChangeProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/changes/GitChangeProvider.<init> must not be null");
        }
        this.myProject = project;
    }

    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, ProgressIndicator progress, ChangeListManagerGate addGate) throws VcsException {
        Collection affected = dirtyScope.getAffectedContentRoots();
        Set<VirtualFile> roots = GitUtil.gitRootsForPaths(affected);
        if (roots.size() != affected.size()) {
            LOG.info("affected content roots size: " + affected.size() + " roots size: " + roots.size());
        }
        MyNonChangedHolder holder = new MyNonChangedHolder(this.myProject, dirtyScope.getDirtyFilesNoExpand());
        for (VirtualFile root : roots) {
            ChangeCollector c = new ChangeCollector(this.myProject, dirtyScope, root);
            Collection<Change> changes = c.changes();
            holder.changed(changes);
            for (Change file : changes) {
                builder.processChange(file, GitVcs.getKey());
            }
            for (VirtualFile f : c.unversioned()) {
                builder.processUnversionedFile(f);
            }
            holder.feedBuilder(builder);
        }
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    private static class MyNonChangedHolder {
        private final Project myProject;
        private final Set<FilePath> myDirty;

        private MyNonChangedHolder(Project project, Set<FilePath> dirty) {
            this.myProject = project;
            this.myDirty = dirty;
        }

        public void changed(Collection<Change> changes) {
            for (Change change : changes) {
                FilePath afterPath;
                FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
                if (beforePath != null) {
                    this.myDirty.remove(beforePath);
                }
                if ((afterPath = ChangesUtil.getBeforePath((Change)change)) == null) continue;
                this.myDirty.remove(afterPath);
            }
        }

        public void feedBuilder(ChangelistBuilder builder) throws VcsException {
            VcsKey gitKey = GitVcs.getKey();
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            for (FilePath filePath : this.myDirty) {
                VirtualFile root;
                VirtualFile vf = filePath.getVirtualFile();
                if (vf == null || !fileDocumentManager.isFileModifiedAndDocumentUnsaved(vf) || (root = vcsManager.getVcsRootFor(vf)) == null) continue;
                GitRevisionNumber beforeRevisionNumber = GitChangeUtils.loadRevision(this.myProject, root, "HEAD");
                builder.processChange(new Change(GitContentRevision.createRevision(vf, beforeRevisionNumber, this.myProject), GitContentRevision.createRevision(vf, null, this.myProject), FileStatus.MODIFIED), gitKey);
            }
        }
    }
}

