/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.GitFileRevision;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitUIUtil;
import org.jetbrains.annotations.NotNull;

public class GitShowAllSubmittedFilesAction
extends AnAction
implements DumbAware {
    public GitShowAllSubmittedFilesAction() {
        super(GitBundle.message("show.all.paths.affected.action.name", new Object[0]), null, IconLoader.getIcon((String)"/icons/allRevisions.png"));
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        e.getPresentation().setEnabled(e.getData(VcsDataKeys.VCS_FILE_REVISION) != null && revisionVirtualFile != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (revision != null && revisionVirtualFile != null) {
            GitFileRevision gitRevision = (GitFileRevision)revision;
            GitShowAllSubmittedFilesAction.showSubmittedFiles(project, gitRevision, revisionVirtualFile);
        }
    }

    public static void showSubmittedFiles(Project project, VcsFileRevision revision, VirtualFile file) {
        GitShowAllSubmittedFilesAction.showSubmittedFiles(project, revision.getRevisionNumber().asString(), file);
    }

    public static void showSubmittedFiles(final Project project, final String revision, final VirtualFile file) {
        GitVcs.getInstance(project).runInBackground(new Task.Backgroundable(project, GitBundle.message("changes.retrieving", revision)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitShowAllSubmittedFilesAction$1.run must not be null");
                }
                indicator.setIndeterminate(true);
                try {
                    VirtualFile vcsRoot = GitUtil.getGitRoot(file);
                    final CommittedChangeList changeList = GitChangeUtils.getRevisionChanges(project, vcsRoot, revision);
                    if (changeList != null) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AbstractVcsHelper.getInstance((Project)project).showChangesListBrowser(changeList, GitShowAllSubmittedFilesAction.getTitle(revision));
                            }
                        });
                    }
                }
                catch (VcsException e) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GitUIUtil.showOperationError(project, e, "git show");
                        }
                    });
                }
            }
        });
    }

    private static String getTitle(String revNumber) {
        return GitBundle.message("paths.affected.title", revNumber);
    }
}

