/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitQuickListContentProvider
implements VcsQuickListContentProvider {
    public List<AnAction> getVcsActions(@Nullable Project project, @Nullable AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null || !"Git".equals(activeVcs.getName())) {
            return null;
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new Separator(activeVcs.getDisplayName()));
        this.add("ChangesView.AddUnversioned", manager, actions);
        this.add("CheckinProject", manager, actions);
        this.add("CheckinFiles", manager, actions);
        this.add("ChangesView.Rollback", manager, actions);
        this.addSeparator(actions);
        this.add("Vcs.ShowTabbedFileHistory", manager, actions);
        this.add("Annotate", manager, actions);
        this.add("Compare.SameVersion", manager, actions);
        this.addSeparator(actions);
        this.add("Git.Checkout", manager, actions);
        this.add("Git.Push.Active.Branches", manager, actions);
        this.add("Git.Stash", manager, actions);
        this.add("Git.Unstash", manager, actions);
        return actions;
    }

    public List<AnAction> getNotInVcsActions(@Nullable Project project, @Nullable DataContext dataContext) {
        AnAction action = ActionManager.getInstance().getAction("Git.Init");
        return Collections.singletonList(action);
    }

    public boolean replaceVcsActionsFor(@NotNull AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitQuickListContentProvider.replaceVcsActionsFor must not be null");
        }
        return "Git".equals(activeVcs.getName());
    }

    private void addSeparator(List<AnAction> actions) {
        actions.add((AnAction)new Separator());
    }

    private void add(String actionName, ActionManager manager, List<AnAction> actions) {
        AnAction action = manager.getAction(actionName);
        assert (action != null);
        actions.add(action);
    }
}

