/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.commands.GitFileUtils;
import git4idea.i18n.GitBundle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitAdd
extends BasicAction {
    @Override
    public boolean perform(final @NotNull Project project, GitVcs vcs, final @NotNull List<VcsException> exceptions, final @NotNull VirtualFile[] affectedFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitAdd.perform must not be null");
        }
        if (exceptions == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitAdd.perform must not be null");
        }
        if (affectedFiles == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of git4idea/actions/GitAdd.perform must not be null");
        }
        GitAdd.saveAll();
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)GitVcs.getInstance(project), affectedFiles)) {
            return false;
        }
        return this.toBackground(project, vcs, affectedFiles, exceptions, new Consumer<ProgressIndicator>(){

            public void consume(ProgressIndicator indicator) {
                try {
                    GitAdd.addFiles(project, affectedFiles, indicator);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        });
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile[] files, ProgressIndicator pi) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitAdd.addFiles must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitAdd.addFiles must not be null");
        }
        Map<VirtualFile, List<VirtualFile>> roots = GitUtil.sortFilesByGitRoot(Arrays.asList(files));
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : roots.entrySet()) {
            pi.setText(entry.getKey().getPresentableUrl());
            GitFileUtils.addFiles(project, entry.getKey(), (Collection<VirtualFile>)entry.getValue());
        }
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("add.action.name");
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/actions/GitAdd.getActionName must not return null");
        }
        return string;
    }

    @Override
    protected boolean isEnabled(@NotNull Project project, @NotNull GitVcs vcs, VirtualFile ... vFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitAdd.isEnabled must not be null");
        }
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitAdd.isEnabled must not be null");
        }
        if (vFiles == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitAdd.isEnabled must not be null");
        }
        for (VirtualFile file : vFiles) {
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
            if (fileStatus != FileStatus.NOT_CHANGED && fileStatus != FileStatus.DELETED) continue;
            return false;
        }
        return true;
    }
}

