/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit.segments;

import com.intellij.rt.execution.junit.segments.Packet;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import java.util.Hashtable;

public abstract class OutputObjectRegistry {
    private final Hashtable myKnownKeys = new Hashtable();
    private int myLastIndex = 0;
    private PacketProcessor myMainTransport;
    private PacketProcessor myAuxilaryTransport;

    public OutputObjectRegistry(PacketProcessor transport) {
        this.myMainTransport = transport;
    }

    public OutputObjectRegistry(PacketProcessor mainTransport, PacketProcessor auxilaryTransport) {
        this(mainTransport);
        this.myAuxilaryTransport = auxilaryTransport;
    }

    public String referenceTo(Object test) {
        if (this.myKnownKeys.containsKey(test)) {
            return (String)this.myKnownKeys.get(test);
        }
        return this.sendObject(test);
    }

    public Packet createPacket() {
        return new Packet(this.myMainTransport, this);
    }

    private String sendObject(Object test) {
        String key = String.valueOf(this.myLastIndex++);
        this.myKnownKeys.put(test, key);
        Packet packet = this.createPacket().addString("O").addReference(key);
        this.addStringRepresentation(test, packet);
        packet.addLong(this.getTestCont(test));
        this.sendViaAllTransports(packet);
        return key;
    }

    protected abstract int getTestCont(Object var1);

    protected abstract void addStringRepresentation(Object var1, Packet var2);

    private void sendViaAllTransports(Packet packet) {
        packet.send();
        if (this.myAuxilaryTransport != null) {
            packet.sendThrough(this.myAuxilaryTransport);
        }
    }

    protected static void addTestClass(Packet packet, String className) {
        packet.addLimitedString("TC").addLimitedString(className);
    }

    protected void addUnknownTest(Packet packet, Object test) {
        packet.addLimitedString("TU").addLong(this.getTestCont(test)).addLimitedString(test.getClass().getName());
    }

    protected static void addAllInPackage(Packet packet, String name) {
        packet.addLimitedString("TN").addLimitedString(name);
    }

    protected static void addTestMethod(Packet packet, String methodName, String className) {
        packet.addLimitedString("TM").addLimitedString(methodName).addLimitedString(className);
    }

    public void forget(Object test) {
        this.myKnownKeys.remove(test);
    }
}

