/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.RegExpPyCondRef;
import org.intellij.lang.regexp.psi.RegExpPyNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.impl.RegExpPropertyImpl;
import org.intellij.lang.regexp.validation.RemoveRedundantEscapeAction;
import org.intellij.lang.regexp.validation.SimplifyQuantifierAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpAnnotator
extends RegExpElementVisitor
implements Annotator {
    private AnnotationHolder myHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/validation/RegExpAnnotator.annotate must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/lang/regexp/validation/RegExpAnnotator.annotate must not be null");
        }
        assert (this.myHolder == null) : "unsupported concurrent annotator invocation";
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitRegExpCharRange(RegExpCharRange range) {
        RegExpCharRange.Endpoint from = range.getFrom();
        RegExpCharRange.Endpoint to = range.getTo();
        boolean a = from instanceof RegExpChar;
        boolean b = to instanceof RegExpChar;
        if (a && b) {
            Character t = ((RegExpChar)to).getValue();
            Character f = ((RegExpChar)from).getValue();
            if (t != null && f != null) {
                if (t.charValue() < f.charValue()) {
                    this.myHolder.createErrorAnnotation((PsiElement)range, "Illegal character range (to < from)");
                } else if (t == f) {
                    this.myHolder.createWarningAnnotation((PsiElement)range, "Redundant character range");
                }
            }
        } else if (a != b) {
            this.myHolder.createErrorAnnotation((PsiElement)range, "Character class (e.g. '\\\\w') may not be used inside character range");
        } else if (from.getText().equals(to.getText())) {
            this.myHolder.createWarningAnnotation((PsiElement)range, "Redundant character range");
        }
    }

    @Override
    public void visitRegExpChar(RegExpChar ch) {
        Character value = ch.getValue();
        if (value == null) {
            switch (ch.getType()) {
                case CHAR: {
                    this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal/unsupported escape sequence");
                    break;
                }
                case HEX: {
                    this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal hexadecimal escape sequence");
                    break;
                }
                case OCT: {
                    this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal octal escape sequence");
                    break;
                }
                case UNICODE: {
                    this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal unicode escape sequence");
                    break;
                }
            }
        } else {
            ASTNode astNode;
            String text = ch.getUnescapedText();
            if (text.startsWith("\\") && RegExpAnnotator.isRedundantEscape(ch, text) && (astNode = ch.getNode().getFirstChildNode()) != null && astNode.getElementType() == RegExpTT.REDUNDANT_ESCAPE) {
                Annotation a = this.myHolder.createInformationAnnotation((PsiElement)ch, "Redundant character escape");
                RegExpAnnotator.registerFix(a, new RemoveRedundantEscapeAction(ch));
            }
        }
    }

    private static boolean isRedundantEscape(RegExpChar ch, String text) {
        if (text.length() <= 1) {
            return false;
        }
        RegExpLanguageHost host = RegExpAnnotator.findRegExpHost(ch);
        if (host != null) {
            char c = text.charAt(1);
            boolean needsEscaping = host.characterNeedsEscaping(c);
            return !needsEscaping;
        }
        return !"\\]".equals(text) && !"\\}".equals(text);
    }

    @Nullable
    private static RegExpLanguageHost findRegExpHost(PsiElement element) {
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        if (host instanceof RegExpLanguageHost) {
            return (RegExpLanguageHost)host;
        }
        return null;
    }

    @Override
    public void visitRegExpProperty(RegExpProperty property) {
        Annotation a;
        ASTNode category = property.getCategoryNode();
        if (category != null && !RegExpPropertyImpl.isValidCategory(category.getText()) && (a = this.myHolder.createErrorAnnotation(category, "Unknown character category")) != null) {
            a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @Override
    public void visitRegExpBackref(RegExpBackref backref) {
        RegExpGroup group = backref.resolve();
        if (group == null) {
            Annotation a = this.myHolder.createErrorAnnotation((PsiElement)backref, "Unresolved backreference");
            if (a != null) {
                a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)backref, (boolean)true)) {
            this.myHolder.createWarningAnnotation((PsiElement)backref, "Backreference is nested into the capturing group it refers to");
        }
    }

    @Override
    public void visitRegExpGroup(RegExpGroup group) {
        RegExpLanguageHost host;
        RegExpPattern pattern = group.getPattern();
        if (pattern != null) {
            RegExpAtom[] atoms;
            RegExpBranch[] branches = pattern.getBranches();
            if (RegExpAnnotator.isEmpty(branches)) {
                this.myHolder.createWarningAnnotation((PsiElement)group, "Empty group");
            } else if (branches.length == 1 && (atoms = branches[0].getAtoms()).length == 1 && atoms[0] instanceof RegExpGroup && group.isSimple()) {
                RegExpGroup innerGroup = (RegExpGroup)atoms[0];
                if (group.isCapturing() == innerGroup.isCapturing()) {
                    this.myHolder.createWarningAnnotation((PsiElement)group, "Redundant group nesting");
                }
            }
        }
        if ((group.isPythonNamedGroup() || group.isRubyNamedGroup()) && ((host = RegExpAnnotator.findRegExpHost(group)) == null || group.isPythonNamedGroup() && !host.supportsPythonNamedGroups() || group.isRubyNamedGroup() && !host.supportsRubyNamedGroups())) {
            this.myHolder.createErrorAnnotation((PsiElement)group, "This named group syntax is not supported");
        }
    }

    @Override
    public void visitRegExpPyNamedGroupRef(RegExpPyNamedGroupRef groupRef) {
        RegExpLanguageHost host = RegExpAnnotator.findRegExpHost(groupRef);
        if (host == null || !host.supportsPythonNamedGroups()) {
            this.myHolder.createErrorAnnotation((PsiElement)groupRef, "This named group reference syntax is not supported");
            return;
        }
        RegExpGroup group = groupRef.resolve();
        if (group == null) {
            Annotation a = this.myHolder.createErrorAnnotation((PsiElement)groupRef, "Unresolved backreference");
            if (a != null) {
                a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)groupRef, (boolean)true)) {
            this.myHolder.createWarningAnnotation((PsiElement)groupRef, "Group reference is nested into the named group it refers to");
        }
    }

    public void visitComment(PsiComment comment) {
        RegExpLanguageHost host;
        if (comment.getText().startsWith("(?#") && ((host = RegExpAnnotator.findRegExpHost((PsiElement)comment)) == null || !host.supportsPerl5EmbeddedComments())) {
            this.myHolder.createErrorAnnotation((PsiElement)comment, "Embedded comments are not supported");
        }
    }

    @Override
    public void visitRegExpPyCondRef(RegExpPyCondRef condRef) {
        RegExpLanguageHost host = RegExpAnnotator.findRegExpHost(condRef);
        if (host == null || !host.supportsPythonConditionalRefs()) {
            this.myHolder.createErrorAnnotation((PsiElement)condRef, "Conditional references are not supported");
        }
    }

    private static boolean isEmpty(RegExpBranch[] branches) {
        for (RegExpBranch branch : branches) {
            if (branch.getAtoms().length <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
        RegExpLanguageHost host;
        RegExpQuantifier.Count count = quantifier.getCount();
        if (!(count instanceof RegExpQuantifier.SimpleCount)) {
            int min = count.getMin();
            int max = count.getMax();
            if (max < min) {
                this.myHolder.createErrorAnnotation((PsiElement)quantifier, "Illegal repetition range");
            } else if (max == min) {
                if (max == 1) {
                    Annotation a = this.myHolder.createInformationAnnotation((PsiElement)quantifier, "Single repetition");
                    RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, null));
                } else {
                    ASTNode node = quantifier.getNode();
                    if (node.findChildByType(RegExpTT.COMMA) != null) {
                        Annotation a = this.myHolder.createInformationAnnotation((PsiElement)quantifier, "Fixed repetition range");
                        RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "{" + max + "}"));
                    }
                }
            } else if (min == 0 && max == 1) {
                Annotation a = this.myHolder.createInformationAnnotation((PsiElement)quantifier, "Repetition range replaceable by '?'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "?"));
            } else if (min == 0 && max == Integer.MAX_VALUE) {
                Annotation a = this.myHolder.createInformationAnnotation((PsiElement)quantifier, "Repetition range replaceable by '*'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "*"));
            } else if (min == 1 && max == Integer.MAX_VALUE) {
                Annotation a = this.myHolder.createInformationAnnotation((PsiElement)quantifier, "Repetition range replaceable by '+'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "+"));
            }
        }
        if (quantifier.getType() == RegExpQuantifier.Type.POSSESSIVE && (host = RegExpAnnotator.findRegExpHost(quantifier)) != null && !host.supportsPossessiveQuantifiers()) {
            this.myHolder.createErrorAnnotation((PsiElement)quantifier, "Nested quantifier in regexp");
        }
    }

    private static void registerFix(Annotation a, IntentionAction action) {
        if (a != null) {
            a.registerFix(action);
        }
    }
}

