/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.ui.SimpleColoredText;
import com.intellij.util.enumeration.EmptyEnumeration;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerNodeLink;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerTreeNode
implements TreeNode {
    protected final XDebuggerTree myTree;
    private final XDebuggerTreeNode myParent;
    private boolean myLeaf;
    protected final SimpleColoredText myText = new SimpleColoredText();
    private Icon myIcon;
    private TreePath myPath;

    protected XDebuggerTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, boolean leaf) {
        this.myParent = parent;
        this.myLeaf = leaf;
        this.myTree = tree;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this.isLeaf()) {
            return null;
        }
        return this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.isLeaf() ? 0 : this.getChildren().size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this.isLeaf()) {
            return -1;
        }
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.myLeaf;
    }

    public Enumeration children() {
        if (this.isLeaf()) {
            return EmptyEnumeration.INSTANCE;
        }
        return Collections.enumeration(this.getChildren());
    }

    protected abstract List<? extends TreeNode> getChildren();

    protected void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public void setLeaf(boolean leaf) {
        this.myLeaf = leaf;
    }

    @Nullable
    public XDebuggerNodeLink getLink() {
        return null;
    }

    @NotNull
    public SimpleColoredText getText() {
        SimpleColoredText simpleColoredText = this.myText;
        if (simpleColoredText == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode.getText must not return null");
        }
        return simpleColoredText;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    protected void fireNodeChanged() {
        this.myTree.getTreeModel().nodeChanged(this);
    }

    protected void fireNodesRemoved(int[] indices, TreeNode[] nodes) {
        if (indices.length > 0) {
            this.myTree.getTreeModel().nodesWereRemoved(this, indices, nodes);
        }
    }

    protected void fireNodesInserted(Collection<? extends TreeNode> added) {
        if (!added.isEmpty()) {
            this.myTree.getTreeModel().nodesWereInserted(this, this.getNodesIndices(added));
        }
    }

    protected TreeNode[] getChildNodes(int[] indices) {
        TreeNode[] children = new TreeNode[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            children[i] = this.getChildAt(indices[i]);
        }
        return children;
    }

    protected int[] getNodesIndices(@Nullable Collection<? extends TreeNode> children) {
        if (children == null) {
            return new int[0];
        }
        int[] ints = new int[children.size()];
        int i = 0;
        for (TreeNode treeNode : children) {
            ints[i++] = this.getIndex(treeNode);
        }
        Arrays.sort(ints);
        return ints;
    }

    protected void fireNodeChildrenChanged() {
        this.myTree.getTreeModel().nodeStructureChanged(this);
    }

    public XDebuggerTree getTree() {
        return this.myTree;
    }

    public TreePath getPath() {
        if (this.myPath == null) {
            TreePath path = this.myParent == null ? new TreePath(this) : this.myParent.getPath().pathByAddingChild(this);
            this.myPath = path;
        }
        return this.myPath;
    }

    @Nullable
    public abstract List<? extends XDebuggerTreeNode> getLoadedChildren();

    public abstract void clearChildren();
}

