/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHintTreeComponent;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.evaluate.quick.XValueHint");
    private final XDebuggerEvaluator myEvaluator;
    private final XDebugSession myDebugSession;
    private final String myExpression;
    @Nullable
    private final XSourcePosition myExpressionPosition;

    public XValueHint(Project project, Editor editor, Point point, ValueHintType type, TextRange textRange, XDebuggerEvaluator evaluator, XDebugSession session) {
        super(project, editor, point, type, textRange);
        this.myEvaluator = evaluator;
        this.myDebugSession = session;
        Document document = editor.getDocument();
        this.myExpression = textRange.substring(document.getText());
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        this.myExpressionPosition = file != null ? XDebuggerUtil.getInstance().createPositionByOffset(file, textRange.getStartOffset()) : null;
    }

    @Override
    protected boolean canShowHint() {
        return true;
    }

    @Override
    protected void evaluateAndShowHint() {
        this.myEvaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)new XEvaluationCallbackBase(){

            public void evaluated(final @NotNull XValue result) {
                if (result == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1.evaluated must not be null");
                }
                result.computePresentation(new XValueNode(){

                    public void setPresentation(@NonNls @NotNull String name, @Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String value, boolean hasChildren) {
                        if (name == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1.setPresentation must not be null");
                        }
                        if (value == null) {
                            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1.setPresentation must not be null");
                        }
                        this.setPresentation(name, icon, type, " = ", value, hasChildren);
                    }

                    public void setPresentation(final @NonNls @NotNull String name, @Nullable Icon icon, @NonNls @Nullable String type, final @NonNls @NotNull String separator, final @NonNls @NotNull String value, final boolean hasChildren) {
                        if (name == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1.setPresentation must not be null");
                        }
                        if (separator == null) {
                            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1.setPresentation must not be null");
                        }
                        if (value == null) {
                            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1.setPresentation must not be null");
                        }
                        DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

                            @Override
                            public void run() {
                                XValueHint.this.doShowHint(result, name, separator, value, hasChildren);
                            }
                        });
                    }

                    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                        if (fullValueEvaluator == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1.setFullValueEvaluator must not be null");
                        }
                    }

                    public boolean isObsolete() {
                        return false;
                    }
                });
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1.errorOccurred must not be null");
                }
                LOG.debug("Cannot evaluate '" + XValueHint.this.myExpression + "':" + errorMessage);
            }
        }, this.myExpressionPosition);
    }

    private void doShowHint(final XValue xValue, final String name, String separator, String value, boolean hasChildren) {
        if (this.isHintHidden()) {
            return;
        }
        SimpleColoredText text = new SimpleColoredText();
        text.append(name, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        text.append(separator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        text.append(value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        JComponent component = !hasChildren ? HintUtil.createInformationLabel(text) : this.createExpandableHintComponent(text, new Runnable(){

            @Override
            public void run() {
                XValueHint.this.showTree(xValue, name);
            }
        });
        this.showHint(component);
    }

    private void showTree(XValue value, String name) {
        XDebuggerTree tree = new XDebuggerTree(this.myDebugSession, this.myDebugSession.getDebugProcess().getEditorsProvider(), this.myDebugSession.getCurrentPosition());
        tree.getModel().addTreeModelListener(this.createTreeListener(tree));
        XValueHintTreeComponent component = new XValueHintTreeComponent(this, tree, (Pair<XValue, String>)Pair.create((Object)value, (Object)name));
        this.showTreePopup(component, tree, name);
    }
}

