/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.ui.AbstractBreakpointPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointsConfigurationDialogFactory {
    @NonNls
    private static final String BREAKPOINT_PANEL = "breakpoint_panel";
    private final Project myProject;
    private final List<BreakpointPanelProvider> myBreakpointPanelProviders;
    private int myLastSelectedTabIndex = -1;

    public static BreakpointsConfigurationDialogFactory getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsConfigurationDialogFactory.getInstance must not be null");
        }
        return (BreakpointsConfigurationDialogFactory)ServiceManager.getService((Project)project, BreakpointsConfigurationDialogFactory.class);
    }

    public BreakpointsConfigurationDialogFactory(Project project) {
        this.myProject = project;
        DebuggerSupport[] debuggerSupports = DebuggerSupport.getDebuggerSupports();
        this.myBreakpointPanelProviders = new ArrayList<BreakpointPanelProvider>();
        for (DebuggerSupport debuggerSupport : debuggerSupports) {
            this.myBreakpointPanelProviders.add(debuggerSupport.getBreakpointPanelProvider());
        }
        Collections.sort(this.myBreakpointPanelProviders, new Comparator<BreakpointPanelProvider>(){

            @Override
            public int compare(BreakpointPanelProvider o1, BreakpointPanelProvider o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
    }

    public BreakpointsConfigurationDialog createDialog(@Nullable Object initialBreakpoint) {
        BreakpointsConfigurationDialog dialog = new BreakpointsConfigurationDialog();
        dialog.selectBreakpoint(initialBreakpoint);
        return dialog;
    }

    public class BreakpointsConfigurationDialog
    extends DialogWrapper {
        private JPanel myPanel;
        @Nullable
        private TabbedPaneWrapper myTabbedPane;
        private JComponent myPreferredComponent;
        @Nullable
        private Runnable myPreparePreferredComponent;
        private final List<Runnable> myDisposeActions;
        private final List<AbstractBreakpointPanel> myPanels;

        public BreakpointsConfigurationDialog() {
            super(BreakpointsConfigurationDialogFactory.this.myProject, true);
            this.myDisposeActions = new ArrayList<Runnable>();
            this.myPanels = new ArrayList<AbstractBreakpointPanel>();
            this.setTitle(XDebuggerBundle.message((String)"xbreakpoints.dialog.title", (Object[])new Object[0]));
            this.setOKButtonText(CommonBundle.message((String)"button.close", (Object[])new Object[0]));
            this.init();
            this.reset();
        }

        @NonNls
        protected String getDimensionServiceKey() {
            return "#com.intellij.debugger.ui.breakpoints.BreakpointsConfigurationDialog";
        }

        protected Action[] createActions() {
            return new Action[]{this.getOKAction(), this.getHelpAction()};
        }

        protected void doHelpAction() {
            AbstractBreakpointPanel currentPanel = this.getSelectedPanel();
            if (currentPanel != null && currentPanel.getHelpID() != null) {
                HelpManager.getInstance().invokeHelp(currentPanel.getHelpID());
            } else {
                super.doHelpAction();
            }
        }

        protected JComponent createCenterPanel() {
            for (BreakpointPanelProvider panelProvider : BreakpointsConfigurationDialogFactory.this.myBreakpointPanelProviders) {
                this.addPanels(panelProvider);
            }
            JComponent contentComponent = null;
            if (this.myPanels.size() > 1) {
                final Disposable tabbedPaneDisposable = new Disposable(){

                    public void dispose() {
                    }
                };
                final TabbedPaneWrapper tabbedPane = new TabbedPaneWrapper(tabbedPaneDisposable);
                for (AbstractBreakpointPanel breakpointPanel : this.myPanels) {
                    this.addPanel(breakpointPanel, tabbedPane);
                }
                final ChangeListener tabPaneChangeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        AbstractBreakpointPanel panel = BreakpointsConfigurationDialog.this.getSelectedPanel();
                        if (panel != null) {
                            panel.ensureSelectionExists();
                        }
                    }
                };
                tabbedPane.addChangeListener(tabPaneChangeListener);
                this.myDisposeActions.add(new Runnable(){

                    @Override
                    public void run() {
                        tabbedPane.removeChangeListener(tabPaneChangeListener);
                        Disposer.dispose((Disposable)tabbedPaneDisposable);
                    }
                });
                this.myTabbedPane = tabbedPane;
                contentComponent = tabbedPane.getComponent();
            } else if (this.myPanels.size() == 1) {
                AbstractBreakpointPanel panel = this.myPanels.get(0);
                this.setTitle(panel.getTabTitle());
                contentComponent = panel.getPanel();
            }
            this.myPanel = new JPanel(new BorderLayout());
            if (contentComponent != null) {
                this.myPanel.add((Component)contentComponent, "Center");
            }
            ActionListener closeAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BreakpointsConfigurationDialog.this.close(1);
                }
            };
            this.myPanel.registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(10, 0), 1);
            this.myPanel.setPreferredSize(new Dimension(600, 500));
            return this.myPanel;
        }

        private <B> void addPanels(BreakpointPanelProvider<B> panelProvider) {
            Collection<AbstractBreakpointPanel<B>> panels = panelProvider.getBreakpointPanels(BreakpointsConfigurationDialogFactory.this.myProject, this);
            for (AbstractBreakpointPanel<B> breakpointPanel : panels) {
                this.myPanels.add(breakpointPanel);
            }
        }

        private void addPanel(final AbstractBreakpointPanel panel, final TabbedPaneWrapper tabbedPane) {
            JPanel jPanel = panel.getPanel();
            jPanel.putClientProperty(BreakpointsConfigurationDialogFactory.BREAKPOINT_PANEL, panel);
            tabbedPane.addTab(panel.getTabTitle(), jPanel);
            final int tabIndex = tabbedPane.getTabCount() - 1;
            final AbstractBreakpointPanel.ChangesListener changesListener = new AbstractBreakpointPanel.ChangesListener(){

                @Override
                public void breakpointsChanged() {
                    BreakpointsConfigurationDialog.this.updateTabTitle(tabbedPane, tabIndex);
                }
            };
            panel.addChangesListener(changesListener);
            this.myDisposeActions.add(new Runnable(){

                @Override
                public void run() {
                    panel.removeChangesListener(changesListener);
                }
            });
        }

        @Nullable
        public AbstractBreakpointPanel getSelectedPanel() {
            if (this.myTabbedPane != null) {
                JComponent selectedComponent = this.myTabbedPane.getSelectedComponent();
                return selectedComponent != null ? (AbstractBreakpointPanel)selectedComponent.getClientProperty(BreakpointsConfigurationDialogFactory.BREAKPOINT_PANEL) : null;
            }
            return (AbstractBreakpointPanel)ContainerUtil.getFirstItem(this.myPanels, null);
        }

        public JComponent getPreferredFocusedComponent() {
            if (this.myPreferredComponent != null) {
                if (this.myPreparePreferredComponent != null) {
                    this.myPreparePreferredComponent.run();
                }
                this.myPreparePreferredComponent = null;
                return this.myPreferredComponent;
            }
            TabbedPaneWrapper tabbedPane = this.myTabbedPane;
            return tabbedPane != null ? IdeFocusTraversalPolicy.getPreferredFocusedComponent(tabbedPane.getComponent()) : null;
        }

        public void setPreferredFocusedComponent(JComponent component, @Nullable Runnable preparePreferredComponent) {
            this.myPreferredComponent = component;
            this.myPreparePreferredComponent = preparePreferredComponent;
        }

        public void dispose() {
            this.apply();
            if (this.myTabbedPane != null) {
                BreakpointsConfigurationDialogFactory.this.myLastSelectedTabIndex = this.myTabbedPane.getSelectedIndex();
            }
            for (Runnable runnable : this.myDisposeActions) {
                runnable.run();
            }
            this.myDisposeActions.clear();
            if (this.myPanel != null) {
                for (AbstractBreakpointPanel panel : this.myPanels) {
                    panel.dispose();
                }
                this.myPanel.removeAll();
                this.myPanel = null;
                this.myTabbedPane = null;
            }
            super.dispose();
        }

        private void apply() {
            for (AbstractBreakpointPanel panel : this.myPanels) {
                panel.saveBreakpoints();
            }
            for (BreakpointPanelProvider panelProvider : BreakpointsConfigurationDialogFactory.this.myBreakpointPanelProviders) {
                panelProvider.onDialogClosed(BreakpointsConfigurationDialogFactory.this.myProject);
            }
        }

        private void reset() {
            for (AbstractBreakpointPanel panel : this.myPanels) {
                panel.resetBreakpoints();
            }
            TabbedPaneWrapper tabbedPane = this.myTabbedPane;
            if (tabbedPane != null) {
                for (int idx = 0; idx < tabbedPane.getTabCount(); ++idx) {
                    this.updateTabTitle(tabbedPane, idx);
                }
                if (BreakpointsConfigurationDialogFactory.this.myLastSelectedTabIndex >= tabbedPane.getTabCount() || BreakpointsConfigurationDialogFactory.this.myLastSelectedTabIndex < 0) {
                    BreakpointsConfigurationDialogFactory.this.myLastSelectedTabIndex = 0;
                    for (int i = 0; i < this.myPanels.size(); ++i) {
                        AbstractBreakpointPanel panel = this.myPanels.get(i);
                        if (!panel.hasBreakpoints()) continue;
                        BreakpointsConfigurationDialogFactory.this.myLastSelectedTabIndex = i;
                        break;
                    }
                }
                tabbedPane.setSelectedIndex(BreakpointsConfigurationDialogFactory.this.myLastSelectedTabIndex);
            }
        }

        private void selectBreakpoint(@Nullable Object breakpoint) {
            if (breakpoint == null) {
                return;
            }
            for (AbstractBreakpointPanel breakpointPanel : this.myPanels) {
                if (this.selectBreakpoint(breakpointPanel, breakpoint)) break;
            }
        }

        private <B> boolean selectBreakpoint(AbstractBreakpointPanel<B> breakpointPanel, Object breakpoint) {
            B b;
            Class<B> aClass = breakpointPanel.getBreakpointClass();
            if (aClass.isInstance(breakpoint) && breakpointPanel.canSelectBreakpoint(b = aClass.cast(breakpoint))) {
                JPanel panel = breakpointPanel.getPanel();
                if (this.myTabbedPane != null) {
                    this.myTabbedPane.setSelectedComponent(panel);
                }
                breakpointPanel.selectBreakpoint(b);
                return true;
            }
            return false;
        }

        private void updateTabTitle(TabbedPaneWrapper tabbedPane, int idx) {
            JComponent component = tabbedPane.getComponentAt(idx);
            for (AbstractBreakpointPanel breakpointPanel : this.myPanels) {
                if (component != breakpointPanel.getPanel()) continue;
                Icon icon = breakpointPanel.getTabIcon();
                tabbedPane.setIconAt(idx, icon);
                break;
            }
        }
    }
}

