/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.intellij.xdebugger.impl.evaluate.EvaluationDialogMode;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import org.jetbrains.annotations.NotNull;

public class XDebuggerEvaluateActionHandler
extends XDebuggerSuspendedActionHandler {
    @Override
    protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
        XValue value;
        String expression;
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler.perform must not be null");
        }
        XDebuggerEditorsProvider editorsProvider = session.getDebugProcess().getEditorsProvider();
        XStackFrame stackFrame = session.getCurrentStackFrame();
        if (stackFrame == null || editorsProvider == null) {
            return;
        }
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator == null) {
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        String string = expression = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (expression == null && (value = XDebuggerTreeActionBase.getSelectedValue(dataContext)) != null) {
            expression = value.getEvaluationExpression();
        }
        if (expression == null) {
            expression = "";
        }
        EvaluationDialogMode mode = expression.indexOf(10) == -1 ? EvaluationDialogMode.EXPRESSION : EvaluationDialogMode.CODE_FRAGMENT;
        XDebuggerEvaluationDialog dialog = new XDebuggerEvaluationDialog(session, editorsProvider, evaluator, expression, mode, stackFrame.getSourcePosition());
        dialog.show();
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler.isEnabled must not be null");
        }
        if (!super.isEnabled(session, dataContext)) {
            return false;
        }
        XStackFrame stackFrame = session.getCurrentStackFrame();
        return stackFrame != null && stackFrame.getEvaluator() != null && session.getDebugProcess().getEditorsProvider() != null;
    }
}

